/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.parsers;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.baomidou.mybatisplus.annotation.DbType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplaceSql {
    private static final Logger log = LoggerFactory.getLogger(ReplaceSql.class);

    private ReplaceSql() {
    }

    public static String replaceSql(DbType dbType, String schemaName, String sql) {
        SQLExprTableSource tableSource;
        SQLExpr where;
        SQLStatement sqlStatement = (switch (dbType) {
            case DbType.SQL_SERVER, DbType.SQL_SERVER2005 -> new SQLServerStatementParser(sql);
            default -> new MySqlStatementParser(sql);
        }).parseStatement();
        if (sqlStatement instanceof SQLSelectStatement) {
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelectQuery sqlSelectQuery = sqlSelectStatement.getSelect().getQuery();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
        }
        if (sqlStatement instanceof SQLUpdateStatement) {
            SQLUpdateStatement sqlUpdateStatement = (SQLUpdateStatement)sqlStatement;
            SQLTableSource sqlTableSource = sqlUpdateStatement.getTableSource();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, sqlTableSource);
            where = sqlUpdateStatement.getWhere();
            ReplaceSql.setSqlSchemaBySqlExpr(schemaName, where);
        }
        if (sqlStatement instanceof SQLInsertStatement) {
            SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)sqlStatement;
            tableSource = sqlInsertStatement.getTableSource();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, (SQLTableSource)tableSource);
        }
        if (sqlStatement instanceof SQLDeleteStatement) {
            SQLDeleteStatement sqlDeleteStatement = (SQLDeleteStatement)sqlStatement;
            tableSource = sqlDeleteStatement.getTableSource();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, (SQLTableSource)tableSource);
            where = sqlDeleteStatement.getWhere();
            ReplaceSql.setSqlSchemaBySqlExpr(schemaName, where);
        }
        if (sqlStatement instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement sqlCreateStatement = (SQLCreateTableStatement)sqlStatement;
            tableSource = sqlCreateStatement.getTableSource();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, (SQLTableSource)tableSource);
        }
        if (sqlStatement instanceof SQLCallStatement) {
            log.info("\u6267\u884c\u5230 \u5b58\u50a8\u8fc7\u7a0b \u8fd9\u91cc\u4e86");
            SQLCallStatement sqlCallStatement = (SQLCallStatement)sqlStatement;
            SQLName expr = sqlCallStatement.getProcedureName();
            if (expr instanceof SQLIdentifierExpr) {
                procedureName = (SQLIdentifierExpr)expr;
                sqlCallStatement.setProcedureName((SQLName)new SQLPropertyExpr(schemaName, procedureName.getName()));
            } else if (expr instanceof SQLPropertyExpr) {
                procedureName = (SQLPropertyExpr)expr;
                sqlCallStatement.setProcedureName((SQLName)new SQLPropertyExpr(schemaName, procedureName.getName()));
            }
        }
        return sqlStatement.toString();
    }

    private static void setSqlSchemaBySqlTableSource(String schemaName, SQLTableSource sqlTableSource) {
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource sqlTableSourceLeft = sqlJoinTableSource.getLeft();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, sqlTableSourceLeft);
            SQLTableSource sqlTableSourceRight = sqlJoinTableSource.getRight();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, sqlTableSourceRight);
            SQLExpr condition = sqlJoinTableSource.getCondition();
            ReplaceSql.setSqlSchemaBySqlExpr(schemaName, condition);
        }
        if (sqlTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource sqlSubqueryTableSource = (SQLSubqueryTableSource)sqlTableSource;
            SQLSelectQuery sqlSelectQuery = sqlSubqueryTableSource.getSelect().getQuery();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
        }
        if (sqlTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)sqlTableSource;
            SQLSelectQuery sqlSelectQueryLeft = sqlUnionQueryTableSource.getUnion().getLeft();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQueryLeft);
            SQLSelectQuery sqlSelectQueryRight = sqlUnionQueryTableSource.getUnion().getRight();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQueryRight);
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            SQLInsertStatement insertStatement;
            SQLSelect sqlSelect;
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            SQLObject sqlObject = sqlExprTableSource.getParent();
            if (sqlObject instanceof SQLDeleteStatement) {
                SQLDeleteStatement deleteStatement = (SQLDeleteStatement)sqlObject;
                SQLExpr sqlExpr = deleteStatement.getWhere();
                ReplaceSql.setSqlSchemaBySqlExpr(schemaName, sqlExpr);
            }
            if (sqlObject instanceof SQLInsertStatement && (sqlSelect = (insertStatement = (SQLInsertStatement)sqlObject).getQuery()) != null) {
                SQLSelectQuery sqlSelectQuery = sqlSelect.getQuery();
                ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
            }
            sqlExprTableSource.setSchema(schemaName);
        }
    }

    private static void setSqlSchemaBySqlBinaryExpr(String schemaName, SQLBinaryOpExpr sqlBinaryOpExpr) {
        SQLExpr sqlExprLeft = sqlBinaryOpExpr.getLeft();
        ReplaceSql.setSqlSchemaBySqlExpr(schemaName, sqlExprLeft);
        SQLExpr sqlExprRight = sqlBinaryOpExpr.getRight();
        ReplaceSql.setSqlSchemaBySqlExpr(schemaName, sqlExprRight);
    }

    private static void setSqlSchemaBySqlExpr(String schemaName, SQLExpr sqlExpr) {
        SQLSelectQuery sqlSelectQuery;
        if (sqlExpr instanceof SQLInSubQueryExpr) {
            SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)sqlExpr;
            sqlSelectQuery = sqlInSubQueryExpr.getSubQuery().getQuery();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLExistsExpr) {
            SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)sqlExpr;
            sqlSelectQuery = sqlExistsExpr.getSubQuery().getQuery();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLCaseExpr) {
            SQLCaseExpr sqlCaseExpr = (SQLCaseExpr)sqlExpr;
            List sqlCaseExprItemList = sqlCaseExpr.getItems();
            for (SQLCaseExpr.Item item : sqlCaseExprItemList) {
                SQLExpr sqlExprItem = item.getValueExpr();
                ReplaceSql.setSqlSchemaBySqlExpr(schemaName, sqlExprItem);
            }
        }
        if (sqlExpr instanceof SQLQueryExpr) {
            SQLQueryExpr sqlQueryExpr = (SQLQueryExpr)sqlExpr;
            sqlSelectQuery = sqlQueryExpr.getSubQuery().getQuery();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)sqlExpr;
            ReplaceSql.setSqlSchemaBySqlBinaryExpr(schemaName, sqlBinaryOpExpr);
        }
        if (sqlExpr instanceof SQLAggregateExpr) {
            SQLAggregateExpr sqlAggregateExpr = (SQLAggregateExpr)sqlExpr;
            List arguments = sqlAggregateExpr.getArguments();
            for (SQLExpr argument : arguments) {
                ReplaceSql.setSqlSchemaBySqlExpr(schemaName, argument);
            }
        }
    }

    private static void setSqlSchemaBySelectQuery(String schemaName, SQLSelectQuery sqlSelectQuery) {
        if (sqlSelectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)sqlSelectQuery;
            SQLSelectQuery sqlSelectQueryLeft = sqlUnionQuery.getLeft();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQueryLeft);
            SQLSelectQuery sqlSelectQueryRight = sqlUnionQuery.getRight();
            ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQueryRight);
        }
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
            SQLTableSource sqlTableSource = sqlSelectQueryBlock.getFrom();
            ReplaceSql.setSqlSchemaBySqlTableSource(schemaName, sqlTableSource);
            SQLExpr whereSqlExpr = sqlSelectQueryBlock.getWhere();
            if (whereSqlExpr instanceof SQLInSubQueryExpr) {
                SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)whereSqlExpr;
                SQLSelectQuery sqlSelectQueryIn = sqlInSubQueryExpr.getSubQuery().getQuery();
                ReplaceSql.setSqlSchemaBySelectQuery(schemaName, sqlSelectQueryIn);
            }
            if (whereSqlExpr instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)whereSqlExpr;
                ReplaceSql.setSqlSchemaBySqlBinaryExpr(schemaName, sqlBinaryOpExpr);
            }
            List sqlSelectItemList = sqlSelectQueryBlock.getSelectList();
            for (SQLSelectItem sqlSelectItem : sqlSelectItemList) {
                SQLExpr sqlExpr = sqlSelectItem.getExpr();
                ReplaceSql.setSqlSchemaBySqlExpr(schemaName, sqlExpr);
                if (!(sqlExpr instanceof SQLMethodInvokeExpr) || !(sqlSelectQuery instanceof SQLSelectQueryBlock) || ((SQLSelectQueryBlock)sqlSelectQuery).getFrom() != null) continue;
                log.info("\u6267\u884c\u5230 \u51fd\u6570 \u8fd9\u91cc\u4e86");
                ((SQLMethodInvokeExpr)sqlExpr).setOwner((SQLExpr)new SQLIdentifierExpr(schemaName));
            }
        }
    }
}

