/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto;

import com.github.tobato.fastdfs.domain.proto.mapper.BytesUtil;
import com.github.tobato.fastdfs.exception.FdfsServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;

public class ProtoHead {
    private static final int HEAD_LENGTH = 10;
    private long contentLength = 0L;
    private final byte cmd;
    private byte status = 0;

    public ProtoHead(byte cmd) {
        this.cmd = cmd;
    }

    public ProtoHead(long contentLength, byte cmd, byte status) {
        this.contentLength = contentLength;
        this.cmd = cmd;
        this.status = status;
    }

    public static ProtoHead createFromInputStream(InputStream ins) throws IOException {
        byte[] header = new byte[10];
        int bytes = ins.read(header);
        if (bytes != header.length) {
            throw new IOException("recv package size " + bytes + " != " + header.length);
        }
        long returnContentLength = BytesUtil.buff2long(header, 0);
        byte returnCmd = header[8];
        byte returnStatus = header[9];
        return new ProtoHead(returnContentLength, returnCmd, returnStatus);
    }

    public byte[] toByte() {
        byte[] header = new byte[10];
        Arrays.fill(header, (byte)0);
        byte[] hexLen = BytesUtil.long2buff(this.contentLength);
        System.arraycopy(hexLen, 0, header, 0, hexLen.length);
        header[8] = this.cmd;
        header[9] = this.status;
        return header;
    }

    public boolean validateResponseHead() throws IOException {
        if (this.cmd != 100) {
            throw new IOException("recv cmd: " + this.cmd + " is not correct, expect cmd: 100");
        }
        if (this.status != 0) {
            throw FdfsServerException.byCode(this.status);
        }
        if (this.contentLength < 0L) {
            throw new IOException("recv body length: " + this.contentLength + " < 0!");
        }
        return true;
    }

    public String toString() {
        return "ProtoHead [contentLength=" + this.contentLength + ", cmd=" + this.cmd + ", status=" + this.status + "]";
    }

    @Generated
    public long getContentLength() {
        return this.contentLength;
    }

    @Generated
    public byte getCmd() {
        return this.cmd;
    }

    @Generated
    public byte getStatus() {
        return this.status;
    }

    @Generated
    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }
}

