/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.storage;

import com.github.tobato.fastdfs.domain.proto.storage.DownloadCallback;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class DownloadFileStream
implements DownloadCallback<BufferedInputStream> {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private OutputStream outputStream;
    private int bufferLength = 4096;

    public DownloadFileStream(OutputStream responseOutputStream) {
        this.outputStream = responseOutputStream;
    }

    public DownloadFileStream(OutputStream responseOutputStream, int bufferLength) {
        this.outputStream = responseOutputStream;
        this.bufferLength = bufferLength;
    }

    @Override
    public BufferedInputStream recv(InputStream ins) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(ins);
        byte[] buffer = new byte[this.bufferLength];
        try {
            IOUtils.copyLarge((InputStream)ins, (OutputStream)this.outputStream, (byte[])buffer);
        }
        catch (IOException e) {
            throw new IOException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25!", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
        return null;
    }
}

