/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.helper.item;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.base.helper.RecyclerAdapterHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u001a\u0010\u0014\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltop/heue/utils/base/helper/item/ItemTouchCallback;", "T", "Landroidx/recyclerview/widget/ItemTouchHelper$Callback;", "adapter", "Ltop/heue/utils/base/helper/RecyclerAdapterHelper;", "Ltop/heue/utils/RA;", "(Ltop/heue/utils/base/helper/RecyclerAdapterHelper;)V", "clearView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getMovementFlags", "", "isItemViewSwipeEnabled", "", "isLongPressDragEnabled", "onMove", "target", "onSelectedChanged", "actionState", "onSwiped", "direction", "base_release"})
public final class ItemTouchCallback<T>
extends ItemTouchHelper.Callback {
    @NotNull
    private final RecyclerAdapterHelper<T> adapter;

    public ItemTouchCallback(@NotNull RecyclerAdapterHelper<T> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.adapter = adapter;
    }

    public int getMovementFlags(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int dragFlags = 12;
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            dragFlags = dragFlags | 1 | 2;
        }
        int swipeFlags = 0;
        return ItemTouchHelper.Callback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int fromPosition = viewHolder.getAdapterPosition();
        int toPosition = target.getAdapterPosition();
        if (fromPosition < toPosition) {
            for (int i = fromPosition; i < toPosition; ++i) {
                Collections.swap(this.adapter.getAllItem(), i, i + 1);
            }
        } else {
            int n = toPosition + 1;
            int i = fromPosition;
            if (n <= i) {
                while (true) {
                    Collections.swap(this.adapter.getAllItem(), i, i - 1);
                    if (i == n) break;
                    --i;
                }
            }
        }
        this.adapter.notifyItemMoved(fromPosition, toPosition);
        return true;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
    }

    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        super.clearView(recyclerView, viewHolder);
    }

    public boolean isLongPressDragEnabled() {
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        return super.isItemViewSwipeEnabled();
    }
}

