/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.view;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Ltop/heue/utils/base/util/view/TabUtil;", "", "()V", "bindTab", "", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "viewPager2", "Landroidx/viewpager2/widget/ViewPager2;", "tabConfigurationStrategy", "Lcom/google/android/material/tabs/TabLayoutMediator$TabConfigurationStrategy;", "hideToolTipText", "tab", "Lcom/google/android/material/tabs/TabLayout$Tab;", "setDivider", "divider", "", "padding", "base_release"})
public final class TabUtil {
    @NotNull
    public static final TabUtil INSTANCE = new TabUtil();

    private TabUtil() {
    }

    public final void bindTab(@NotNull TabLayout tabLayout, @NotNull ViewPager2 viewPager2, @NotNull TabLayoutMediator.TabConfigurationStrategy tabConfigurationStrategy) {
        Intrinsics.checkNotNullParameter((Object)tabLayout, (String)"tabLayout");
        Intrinsics.checkNotNullParameter((Object)viewPager2, (String)"viewPager2");
        Intrinsics.checkNotNullParameter((Object)tabConfigurationStrategy, (String)"tabConfigurationStrategy");
        new TabLayoutMediator(tabLayout, viewPager2, true, tabConfigurationStrategy).attach();
    }

    public final void hideToolTipText(@NotNull TabLayout.Tab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        tab.view.setLongClickable(false);
        if (Build.VERSION.SDK_INT > 26) {
            tab.view.setTooltipText((CharSequence)"");
        }
    }

    public final void setDivider(@NotNull TabLayout tabLayout, @DrawableRes int divider, int padding) {
        Intrinsics.checkNotNullParameter((Object)tabLayout, (String)"tabLayout");
        View view = tabLayout.getChildAt(0);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.LinearLayout");
        LinearLayout linearLayout = (LinearLayout)view;
        linearLayout.setShowDividers(2);
        linearLayout.setDividerDrawable(ContextCompat.getDrawable((Context)tabLayout.getContext(), (int)divider));
        linearLayout.setDividerPadding(padding);
    }

    public static /* synthetic */ void setDivider$default(TabUtil tabUtil, TabLayout tabLayout, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        tabUtil.setDivider(tabLayout, n, n2);
    }
}

