/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.base.util.system;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.base.util.system.BarUtil;
import top.heue.utils.base.util.system.ProcessUtil;
import top.heue.utils.base.util.system.RestartUtil;
import top.heue.utils.base.util.system.SystemBarUtil;
import top.heue.utils.base.util.system.VerifyUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#J\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020!J,\u0010+\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ltop/heue/utils/base/util/system/SystemUtil;", "", "()V", "BRAND_HONOR", "", "BRAND_HTC", "BRAND_HUAWEI", "BRAND_LENOVO", "BRAND_LG", "BRAND_Letv", "BRAND_MEIZU", "BRAND_NOVA", "BRAND_OPPO", "BRAND_OnePlus", "BRAND_REDMI", "BRAND_SAMSUNG", "BRAND_SMARTISAN", "BRAND_SONY", "BRAND_VIVO", "BRAND_XIAOMI", "getDeviceBrand", "getSystemLanguage", "getSystemLanguageList", "", "Ljava/util/Locale;", "()[Ljava/util/Locale;", "getSystemModel", "getSystemVersion", "hideBar", "", "activity", "Landroid/app/Activity;", "isDarkMode", "", "context", "Landroid/content/Context;", "isMainProcess", "isServiceRunning", "serviceName", "loggable", "restart", "setBarDarkMode", "isDark", "underBar", "drawable", "Landroid/graphics/drawable/Drawable;", "contentView", "Landroid/view/View;", "contentDrawable", "base_release"})
public final class SystemUtil {
    @NotNull
    public static final SystemUtil INSTANCE = new SystemUtil();
    @NotNull
    public static final String BRAND_HUAWEI = "Huawei";
    @NotNull
    public static final String BRAND_HONOR = "HONOR";
    @NotNull
    public static final String BRAND_NOVA = "nova";
    @NotNull
    public static final String BRAND_XIAOMI = "xiaomi";
    @NotNull
    public static final String BRAND_REDMI = "Redmi";
    @NotNull
    public static final String BRAND_VIVO = "vivo";
    @NotNull
    public static final String BRAND_MEIZU = "Meizu";
    @NotNull
    public static final String BRAND_SONY = "sony";
    @NotNull
    public static final String BRAND_SAMSUNG = "samsung";
    @NotNull
    public static final String BRAND_OPPO = "OPPO";
    @NotNull
    public static final String BRAND_Letv = "letv";
    @NotNull
    public static final String BRAND_OnePlus = "OnePlus";
    @NotNull
    public static final String BRAND_SMARTISAN = "smartisan";
    @NotNull
    public static final String BRAND_LENOVO = "lenovo";
    @NotNull
    public static final String BRAND_LG = "lg";
    @NotNull
    public static final String BRAND_HTC = "htc";

    private SystemUtil() {
    }

    @Nullable
    public final String getSystemLanguage() {
        return Locale.getDefault().getLanguage();
    }

    @Nullable
    public final Locale[] getSystemLanguageList() {
        return Locale.getAvailableLocales();
    }

    @Nullable
    public final String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    @Nullable
    public final String getSystemModel() {
        return Build.MODEL;
    }

    @Nullable
    public final String getDeviceBrand() {
        return Build.BRAND;
    }

    public final boolean isDarkMode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int mode = context.getApplicationContext().getResources().getConfiguration().uiMode;
        return mode == 33;
    }

    public final void setBarDarkMode(@NotNull Activity activity2, boolean isDark) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        BarUtil.INSTANCE.setMode(activity2, isDark);
    }

    public final void hideBar(@NotNull Activity activity2) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        WindowManager.LayoutParams layoutParams = activity2.getWindow().getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"activity.window.attributes");
        WindowManager.LayoutParams lp = layoutParams;
        if (Build.VERSION.SDK_INT >= 28) {
            lp.layoutInDisplayCutoutMode = 0;
        }
        activity2.getWindow().setAttributes(lp);
        SystemBarUtil.hideSystemBar(activity2);
    }

    public final void underBar(@NotNull Activity activity2, @NotNull Drawable drawable, @Nullable View contentView, @Nullable Drawable contentDrawable) {
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Drawable drawable2 = contentDrawable;
        if (drawable2 == null) {
            drawable2 = activity2.getWindow().getDecorView().getBackground();
        }
        Drawable d = drawable2;
        View view = contentView;
        if (view != null) {
            view.setBackground(d);
        }
        activity2.getWindow().setBackgroundDrawable(drawable);
    }

    public static /* synthetic */ void underBar$default(SystemUtil systemUtil, Activity activity2, Drawable drawable, View view, Drawable drawable2, int n, Object object) {
        if ((n & 8) != 0) {
            drawable2 = null;
        }
        systemUtil.underBar(activity2, drawable, view, drawable2);
    }

    public final boolean isServiceRunning(@NotNull Context context, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return ProcessUtil.INSTANCE.isServiceRunning(context, serviceName);
    }

    public final boolean isMainProcess(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ProcessUtil.INSTANCE.isMainProcess(context);
    }

    public final void restart(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RestartUtil.INSTANCE.restart(context);
    }

    public final boolean loggable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return VerifyUtil.loggable(context);
    }
}

