/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.mrbean;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JavaType;

public class BeanUtil {
    protected static boolean isConcrete(Member member) {
        int mod = member.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static List<JavaType> findSuperTypes(JavaType type, Class<?> endBefore) {
        return BeanUtil.findSuperTypes(type, endBefore, new ArrayList<JavaType>());
    }

    public static List<JavaType> findSuperTypes(JavaType type, Class<?> endBefore, List<JavaType> result) {
        BeanUtil._addSuperTypes(type, endBefore, result, false);
        return result;
    }

    private static void _addSuperTypes(JavaType type, Class<?> endBefore, List<JavaType> result, boolean addClassItself) {
        if (type == null || type.isJavaLangObject() || type.hasRawClass(endBefore)) {
            return;
        }
        if (addClassItself) {
            if (result.contains(type)) {
                return;
            }
            result.add(type);
        }
        for (JavaType intCls : type.getInterfaces()) {
            BeanUtil._addSuperTypes(intCls, endBefore, result, true);
        }
        BeanUtil._addSuperTypes(type.getSuperClass(), endBefore, result, true);
    }
}

