/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.mrbean;

import java.lang.reflect.Method;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.module.mrbean.BeanUtil;

public class POJOProperty {
    protected final String _name;
    protected final String _fieldName;
    protected final TypeResolutionContext _context;
    protected Method _getter;
    protected Method _setter;

    public POJOProperty(TypeResolutionContext ctxt, String name) {
        this._name = name;
        this._context = ctxt;
        this._fieldName = name;
    }

    public String getName() {
        return this._name;
    }

    public void setGetter(Method m) {
        this._getter = m;
    }

    public void setSetter(Method m) {
        this._setter = m;
    }

    public Method getGetter() {
        return this._getter;
    }

    public Method getSetter() {
        return this._setter;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public boolean hasConcreteGetter() {
        return this._getter != null && BeanUtil.isConcrete(this._getter);
    }

    public boolean hasConcreteSetter() {
        return this._setter != null && BeanUtil.isConcrete(this._setter);
    }

    private JavaType getterType() {
        return this._context.resolveType(this._getter.getGenericReturnType());
    }

    private JavaType setterType() {
        return this._context.resolveType(this._setter.getGenericParameterTypes()[0]);
    }

    public JavaType selectType() {
        JavaType gt;
        if (this._getter == null) {
            return this.setterType();
        }
        if (this._setter == null) {
            return this.getterType();
        }
        JavaType st = this.setterType();
        JavaType specificType = this.moreSpecificType(st, gt = this.getterType());
        if (specificType == null) {
            throw new IllegalArgumentException("Invalid property '" + this.getName() + "': incompatible types for getter/setter (" + String.valueOf(gt) + " vs " + String.valueOf(st) + ")");
        }
        return specificType;
    }

    private JavaType moreSpecificType(JavaType desc1, JavaType desc2) {
        Class c2;
        Class c1 = desc1.getRawClass();
        if (c1.isAssignableFrom(c2 = desc2.getRawClass())) {
            return desc2;
        }
        if (c2.isAssignableFrom(c1)) {
            return desc1;
        }
        return null;
    }
}

