/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.mrbean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.module.mrbean.BeanUtil;
import tools.jackson.module.mrbean.ByteBuddyBuilderUtil;
import tools.jackson.module.mrbean.POJOProperty;
import tools.jackson.module.mrbean.TypeDefinitionUtil;
import tools.jackson.module.mrbean.bytebuddy.ByteBuddy;
import tools.jackson.module.mrbean.bytebuddy.description.modifier.ModifierContributor;
import tools.jackson.module.mrbean.bytebuddy.description.modifier.Visibility;
import tools.jackson.module.mrbean.bytebuddy.description.type.TypeDefinition;
import tools.jackson.module.mrbean.bytebuddy.dynamic.DynamicType;
import tools.jackson.module.mrbean.bytebuddy.dynamic.scaffold.TypeValidation;
import tools.jackson.module.mrbean.bytebuddy.implementation.ExceptionMethod;
import tools.jackson.module.mrbean.bytebuddy.implementation.FieldAccessor;

public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final JavaType _type;
    protected final AnnotatedClass _typeDefinition;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(JavaType type, AnnotatedClass ac, TypeFactory tf) {
        this._type = type;
        this._typeDefinition = ac;
        this._typeFactory = tf;
    }

    public static BeanBuilder construct(MapperConfig<?> config, JavaType type, AnnotatedClass ac) {
        return new BeanBuilder(type, ac, config.getTypeFactory());
    }

    public BeanBuilder implement(boolean failOnUnrecognized) {
        ArrayList<JavaType> implTypes = new ArrayList<JavaType>();
        implTypes.add(this._type);
        BeanUtil.findSuperTypes(this._type, Object.class, implTypes);
        for (JavaType impl : implTypes) {
            TypeResolutionContext ctxt = this.buildTypeContext(impl);
            for (Method m : impl.getRawClass().getDeclaredMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || m.isSynthetic() || m.isBridge()) continue;
                String methodName = m.getName();
                int argCount = m.getParameterTypes().length;
                if (argCount == 0) {
                    if (methodName.startsWith("get")) {
                        if (methodName.length() > 3) {
                            this.addGetter(ctxt, m);
                            continue;
                        }
                    } else if (methodName.startsWith("is") && methodName.length() > 2 && BeanBuilder.returnsBoolean(m)) {
                        this.addGetter(ctxt, m);
                        continue;
                    }
                } else if (argCount == 1 && methodName.startsWith("set") && methodName.length() > 3) {
                    this.addSetter(ctxt, m);
                    continue;
                }
                if (BeanUtil.isConcrete(m) || this._unsupportedMethods.containsKey(methodName) || this.hasConcreteOverride(m, this._type)) continue;
                if (failOnUnrecognized) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + methodName + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(methodName, m);
            }
        }
        return this;
    }

    public byte[] build(String className) {
        DynamicType.Builder<Object> builder = new ByteBuddy().with(TypeValidation.DISABLED).subclass(this._type.getRawClass()).name(className);
        for (POJOProperty prop : this._beanProperties.values()) {
            TypeDefinition typeDefinition = this.getFieldType(prop);
            builder = this.createField(builder, prop, typeDefinition);
            if (!prop.hasConcreteGetter()) {
                builder = this.createGetter(builder, prop, typeDefinition);
            }
            if (prop.hasConcreteSetter()) continue;
            builder = this.createSetter(builder, prop, typeDefinition);
        }
        for (Method m : this._unsupportedMethods.values()) {
            builder = builder.defineMethod(m.getName(), m.getReturnType(), Visibility.PUBLIC).intercept(ExceptionMethod.throwing(UnsupportedOperationException.class, "Unimplemented method '" + m.getName() + "' (not a setter/getter, could not materialize)"));
        }
        if (this._type.isInterface()) {
            builder = ByteBuddyBuilderUtil.createEqualsAndHashCode(builder);
        }
        return builder.make().getBytes();
    }

    protected boolean hasConcreteOverride(Method m0, JavaType implementedType) {
        String name = m0.getName();
        Class<?>[] argTypes = m0.getParameterTypes();
        try {
            Method effectiveMethod = implementedType.getRawClass().getMethod(name, argTypes);
            return BeanUtil.isConcrete(effectiveMethod);
        }
        catch (NoSuchMethodException effectiveMethod) {
            for (JavaType curr = implementedType; curr != null && !curr.isJavaLangObject(); curr = curr.getSuperClass()) {
                try {
                    Method effectiveMethod2 = curr.getRawClass().getDeclaredMethod(name, argTypes);
                    return BeanUtil.isConcrete(effectiveMethod2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return false;
        }
    }

    protected String getPropertyName(String methodName) {
        int prefixLen = methodName.startsWith("is") ? 2 : 3;
        return this.decap(methodName.substring(prefixLen));
    }

    protected String buildGetterName(String fieldName) {
        return this.cap("get", fieldName);
    }

    protected String buildSetterName(String fieldName) {
        return this.cap("set", fieldName);
    }

    protected String getInternalClassName(String className) {
        return className.replace(".", "/");
    }

    protected void addGetter(TypeResolutionContext ctxt, Method m) {
        POJOProperty prop = this.findProperty(ctxt, this.getPropertyName(m.getName()));
        if (prop.getGetter() == null) {
            prop.setGetter(m);
        }
    }

    protected void addSetter(TypeResolutionContext ctxt, Method m) {
        POJOProperty prop = this.findProperty(ctxt, this.getPropertyName(m.getName()));
        if (prop.getSetter() == null) {
            prop.setSetter(m);
        }
    }

    protected POJOProperty findProperty(TypeResolutionContext ctxt, String propName) {
        POJOProperty prop = this._beanProperties.get(propName);
        if (prop == null) {
            prop = new POJOProperty(ctxt, propName);
            this._beanProperties.put(propName, prop);
        }
        return prop;
    }

    protected static final boolean returnsBoolean(Method m) {
        Class<?> rt = m.getReturnType();
        return rt == Boolean.class || rt == Boolean.TYPE;
    }

    private TypeDefinition getFieldType(POJOProperty property) {
        return TypeDefinitionUtil.createTypeDefinitionFromJavaType(property.selectType());
    }

    private DynamicType.Builder<?> createField(DynamicType.Builder<?> builder, POJOProperty property, TypeDefinition typeDefinition) {
        return builder.defineField(property.getName(), typeDefinition, Visibility.PROTECTED);
    }

    private DynamicType.Builder<?> createGetter(DynamicType.Builder<?> builder, POJOProperty property, TypeDefinition typeDefinition) {
        String methodName = property.getGetter() != null ? property.getGetter().getName() : this.buildGetterName(property.getName());
        return builder.defineMethod(methodName, typeDefinition, new ModifierContributor.ForMethod[0]).intercept(FieldAccessor.ofBeanProperty());
    }

    private DynamicType.Builder<?> createSetter(DynamicType.Builder<?> builder, POJOProperty property, TypeDefinition typeDefinition) {
        return builder.defineMethod(this.buildSetterName(property.getName()), Void.TYPE, Visibility.PUBLIC).withParameters(typeDefinition).intercept(FieldAccessor.ofBeanProperty());
    }

    protected String decap(String name) {
        char c = name.charAt(0);
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(c)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(c);
        return new String(chars);
    }

    protected String cap(String prefix, String name) {
        int plen = prefix.length();
        StringBuilder sb = new StringBuilder(plen + name.length());
        sb.append(prefix);
        sb.append(name);
        sb.setCharAt(plen, Character.toUpperCase(name.charAt(0)));
        return sb.toString();
    }

    protected TypeResolutionContext buildTypeContext(JavaType ctxtType) {
        return new TypeResolutionContext.Basic(this._typeFactory, ctxtType.getBindings());
    }
}

