/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.deser.jdk.JDKKeyDeserializers;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.ReflectionCache;
import tools.jackson.module.kotlin.UByteKeyDeserializer;
import tools.jackson.module.kotlin.UIntKeyDeserializer;
import tools.jackson.module.kotlin.ULongKeyDeserializer;
import tools.jackson.module.kotlin.UShortKeyDeserializer;
import tools.jackson.module.kotlin.ValueClassKeyDeserializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltools/jackson/module/kotlin/KotlinKeyDeserializers;", "Ltools/jackson/databind/deser/jdk/JDKKeyDeserializers;", "cache", "Ltools/jackson/module/kotlin/ReflectionCache;", "<init>", "(Ltools/jackson/module/kotlin/ReflectionCache;)V", "findKeyDeserializer", "Ltools/jackson/databind/KeyDeserializer;", "type", "Ltools/jackson/databind/JavaType;", "config", "Ltools/jackson/databind/DeserializationConfig;", "beanDescRef", "Ltools/jackson/databind/BeanDescription$Supplier;", "jackson-module-kotlin"})
public final class KotlinKeyDeserializers
extends JDKKeyDeserializers {
    @NotNull
    private final ReflectionCache cache;

    public KotlinKeyDeserializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Nullable
    public KeyDeserializer findKeyDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @Nullable BeanDescription.Supplier beanDescRef) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class rawClass = type.getRawClass();
        if (Intrinsics.areEqual((Object)rawClass, UByte.class)) {
            object = (KeyDeserializer)UByteKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UShort.class)) {
            object = (KeyDeserializer)UShortKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, UInt.class)) {
            object = (KeyDeserializer)UIntKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)rawClass, ULong.class)) {
            object = (KeyDeserializer)ULongKeyDeserializer.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)rawClass);
            object = InternalCommonsKt.isUnboxableValueClass(rawClass) ? (KeyDeserializer)ValueClassKeyDeserializer.Companion.createOrNull(JvmClassMappingKt.getKotlinClass((Class)rawClass), this.cache) : null;
        }
        return object;
    }
}

