/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.jaxb;

import com.fasterxml.jackson.annotation.JsonInclude;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.JacksonModule;
import tools.jackson.module.jaxb.JaxbAnnotationIntrospector;
import tools.jackson.module.jaxb.PackageVersion;

public class JaxbAnnotationModule
extends JacksonModule {
    protected Priority _priority = Priority.PRIMARY;
    protected JaxbAnnotationIntrospector _introspector;
    protected JsonInclude.Include _nonNillableInclusion;
    protected String _nameUsedForXmlValue = "value";

    public JaxbAnnotationModule() {
    }

    public JaxbAnnotationModule(JaxbAnnotationIntrospector intr) {
        this._introspector = intr;
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setupModule(JacksonModule.SetupContext context) {
        JaxbAnnotationIntrospector intr = this._introspector;
        if (intr == null) {
            intr = new JaxbAnnotationIntrospector();
            if (this._nonNillableInclusion != null) {
                intr.setNonNillableInclusion(this._nonNillableInclusion);
            }
            intr.setNameUsedForXmlValue(this._nameUsedForXmlValue);
        }
        switch (this._priority) {
            case PRIMARY: {
                context.insertAnnotationIntrospector((AnnotationIntrospector)intr);
                break;
            }
            case SECONDARY: {
                context.appendAnnotationIntrospector((AnnotationIntrospector)intr);
            }
        }
    }

    public JaxbAnnotationModule setPriority(Priority p) {
        this._priority = p;
        return this;
    }

    public Priority getPriority() {
        return this._priority;
    }

    public JaxbAnnotationModule setNonNillableInclusion(JsonInclude.Include incl) {
        this._nonNillableInclusion = incl;
        if (this._introspector != null) {
            this._introspector.setNonNillableInclusion(incl);
        }
        return this;
    }

    public JsonInclude.Include getNonNillableInclusion() {
        return this._nonNillableInclusion;
    }

    public JaxbAnnotationModule setNameUsedForXmlValue(String name) {
        this._nameUsedForXmlValue = name;
        return this;
    }

    public String getNameUsedForXmlValue() {
        return this._nameUsedForXmlValue;
    }

    public static enum Priority {
        PRIMARY,
        SECONDARY;

    }
}

