/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.util.bytebuddy;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;

public class SimpleExceptionHandler
implements Implementation,
ByteCodeAppender {
    private final StackManipulation exceptionThrowingAppender;
    private final StackManipulation exceptionHandlerAppender;
    private final Class<? extends Exception> exceptionType;
    private final int newLocalVariablesCount;

    public SimpleExceptionHandler(StackManipulation exceptionThrowingAppender, StackManipulation exceptionHandlerAppender, Class<? extends Exception> exceptionType, int newLocalVariablesCount) {
        this.exceptionThrowingAppender = exceptionThrowingAppender;
        this.exceptionHandlerAppender = exceptionHandlerAppender;
        this.exceptionType = exceptionType;
        this.newLocalVariablesCount = newLocalVariablesCount;
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        Label startTryBlock = new Label();
        Label endTryBlock = new Label();
        Label startCatchBlock = new Label();
        StackManipulation preTriggerAppender = this.preTrigger(startTryBlock, endTryBlock, startCatchBlock);
        StackManipulation postTriggerAppender = this.postTrigger(endTryBlock, startCatchBlock);
        StackManipulation.Compound delegate = new StackManipulation.Compound(new StackManipulation[]{preTriggerAppender, this.exceptionThrowingAppender, postTriggerAppender, this.exceptionHandlerAppender});
        StackManipulation.Size operandStackSize = delegate.apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), instrumentedMethod.getStackSize() + this.newLocalVariablesCount);
    }

    private StackManipulation preTrigger(final Label startTryBlock, final Label endTryBlock, final Label startCatchBlock) {
        return new StackManipulation(){

            public boolean isValid() {
                return true;
            }

            public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context ic) {
                String name = SimpleExceptionHandler.this.exceptionType.getName();
                mv.visitTryCatchBlock(startTryBlock, endTryBlock, startCatchBlock, name.replace(".", "/"));
                mv.visitLabel(startTryBlock);
                return new StackManipulation.Size(0, 0);
            }
        };
    }

    private StackManipulation postTrigger(final Label endTryBlock, final Label startCatchBlock) {
        return new StackManipulation(){

            public boolean isValid() {
                return true;
            }

            public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context ic) {
                mv.visitLabel(endTryBlock);
                mv.visitLabel(startCatchBlock);
                return new StackManipulation.Size(1, 0);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleExceptionHandler that = (SimpleExceptionHandler)o;
        if (!this.exceptionThrowingAppender.equals(that.exceptionThrowingAppender)) {
            return false;
        }
        if (!this.exceptionHandlerAppender.equals(that.exceptionHandlerAppender)) {
            return false;
        }
        return this.exceptionType.equals(that.exceptionType);
    }

    public int hashCode() {
        int result = this.exceptionThrowingAppender.hashCode();
        result = 31 * result + this.exceptionHandlerAppender.hashCode();
        result = 31 * result + this.exceptionType.hashCode();
        return result;
    }
}

