/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class StringMethodPropertyWriter
extends OptimizedBeanPropertyWriter<StringMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;

    public StringMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, ValueSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    protected StringMethodPropertyWriter(StringMethodPropertyWriter base, PropertyName name) {
        super(base, name);
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new StringMethodPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new StringMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringMethodPropertyWriter(this, acc, this._propertyIndex, (ValueSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.stringGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (value == null) {
            if (this._suppressableValue != null && ctxt.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                g.writeName(this._fastName);
                this._nullSerializer.serialize(null, g, ctxt);
            }
            return;
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
            return;
        }
        g.writeName(this._fastName);
        g.writeString(value);
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        String value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.stringGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (value == null) {
            if (this._suppressNulls) {
                this.serializeAsOmittedElement(bean, g, ctxt);
            } else {
                ctxt.defaultSerializeNullValue(g);
            }
            return;
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (value.length() == 0) {
                    this.serializeAsOmittedElement(bean, g, ctxt);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsOmittedElement(bean, g, ctxt);
                return;
            }
        }
        g.writeString(value);
    }
}

