/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class BooleanMethodPropertyWriter
extends OptimizedBeanPropertyWriter<BooleanMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final boolean _suppressableSet;
    private final boolean _suppressableBoolean;

    public BooleanMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, ValueSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue instanceof Boolean) {
            this._suppressableBoolean = (Boolean)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableBoolean = false;
            this._suppressableSet = false;
        }
    }

    protected BooleanMethodPropertyWriter(BooleanMethodPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableSet = base._suppressableSet;
        this._suppressableBoolean = base._suppressableBoolean;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new BooleanMethodPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new BooleanMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public BooleanMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new BooleanMethodPropertyWriter(this, acc, this._propertyIndex, (ValueSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            g.writeName(this._fastName);
            g.writeBoolean(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            g.writeBoolean(value);
        } else {
            this.serializeAsOmittedElement(bean, g, ctxt);
        }
    }
}

