/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.Named;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.BeanConstructors;
import tools.jackson.jr.ob.impl.BeanPropertyReader;
import tools.jackson.jr.ob.impl.JSONReader;
import tools.jackson.jr.ob.impl.RecordsHelpers;

public class BeanReader
extends ValueReader {
    protected final Map<String, BeanPropertyReader> _propsByName;
    protected final Map<String, String> _aliasMapping;
    protected final Set<String> _ignorableNames;
    protected final boolean _caseInsensitive;
    protected final BeanConstructors _constructors;
    protected final boolean _isRecordType;
    protected final Object[] _recordNullValues;
    protected PropertyNameMatcher _propNameMatcher;
    protected BeanPropertyReader[] _propValueReaders;

    protected BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, BeanConstructors beanConstructors, Set<String> set, Map<String, String> map2, boolean bl) {
        super(clazz);
        this._isRecordType = RecordsHelpers.isRecordType(clazz);
        this._propsByName = map;
        this._constructors = beanConstructors;
        this._ignorableNames = set;
        this._aliasMapping = map2;
        this._caseInsensitive = bl;
        if (this._isRecordType) {
            this._recordNullValues = new Object[this._propsByName.size()];
            for (int i = 0; i < this._recordNullValues.length; ++i) {
                for (BeanPropertyReader beanPropertyReader : this._propsByName.values()) {
                    if (beanPropertyReader.getIndex() != i) continue;
                    this._recordNullValues[i] = this.nullValue(beanPropertyReader.rawSetterType());
                }
            }
        } else {
            this._recordNullValues = null;
        }
    }

    protected void initPropertyMatcher(TokenStreamFactory tokenStreamFactory) {
        Map<String, BeanPropertyReader> map = this._aliasMapping.isEmpty() ? this._propsByName : this._mixInAliases(this._propsByName, this._aliasMapping);
        int n = map.size();
        ArrayList<Named> arrayList = new ArrayList<Named>(n);
        this._propValueReaders = new BeanPropertyReader[n];
        int n2 = 0;
        for (Map.Entry<String, BeanPropertyReader> entry : map.entrySet()) {
            arrayList.add(Named.fromString((String)entry.getKey()));
            this._propValueReaders[n2++] = entry.getValue();
        }
        this._propNameMatcher = this._caseInsensitive ? tokenStreamFactory.constructCINameMatcher(arrayList, false, Locale.getDefault()) : tokenStreamFactory.constructNameMatcher(arrayList, false);
    }

    private final Map<String, BeanPropertyReader> _mixInAliases(Map<String, BeanPropertyReader> map, Map<String, String> map2) {
        LinkedHashMap<String, BeanPropertyReader> linkedHashMap = new LinkedHashMap<String, BeanPropertyReader>(map);
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            BeanPropertyReader beanPropertyReader;
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (map.containsKey(string) || (beanPropertyReader = map.get(string2)) == null) continue;
            linkedHashMap.put(string, beanPropertyReader);
        }
        return linkedHashMap;
    }

    public static BeanReader construct(Class<?> clazz, Map<String, BeanPropertyReader> map, BeanConstructors beanConstructors, Set<String> set, Map<String, String> map2, boolean bl) {
        if (set == null) {
            set = Collections.emptySet();
        }
        if (map2 == null) {
            map2 = Collections.emptyMap();
        }
        return new BeanReader(clazz, map, beanConstructors, set, map2, bl);
    }

    public Map<String, BeanPropertyReader> propertiesByName() {
        return this._propsByName;
    }

    public BeanPropertyReader findProperty(String string) {
        return this._propsByName.get(string);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        if (jsonParser.isExpectedStartObjectToken()) {
            Object object;
            if (this._isRecordType) {
                return this.readRecord(jSONReader, jsonParser);
            }
            try {
                object = this._constructors.create();
            }
            catch (Exception exception) {
                return this._reportFailureToCreate(jsonParser, exception);
            }
            jsonParser.assignCurrentValue(object);
            return this._readBean(jSONReader, jsonParser, object);
        }
        try {
            switch (jsonParser.currentTokenId()) {
                case 11: {
                    return null;
                }
                case 6: {
                    return this._constructors.create(jsonParser.getString());
                }
                case 7: {
                    return this._constructors.create(jsonParser.getLongValue());
                }
            }
        }
        catch (Exception exception) {
            return this._reportFailureToCreate(jsonParser, exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a %s instance out of %s", this._valueType.getName(), BeanReader._tokenDesc(jsonParser));
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            Object object;
            if (this._isRecordType) {
                return this.readRecord(jSONReader, jsonParser);
            }
            try {
                object = this._constructors.create();
            }
            catch (Exception exception) {
                return this._reportFailureToCreate(jsonParser, exception);
            }
            jsonParser.assignCurrentValue(object);
            return this._readBean(jSONReader, jsonParser, object);
        }
        if (jsonToken != null) {
            try {
                switch (jsonToken) {
                    case VALUE_NULL: {
                        return null;
                    }
                    case VALUE_STRING: {
                        return this._constructors.create(jsonParser.getString());
                    }
                    case VALUE_NUMBER_INT: {
                        return this._constructors.create(jsonParser.getLongValue());
                    }
                }
            }
            catch (Exception exception) {
                return this._reportFailureToCreate(jsonParser, exception);
            }
        }
        throw JSONObjectException.from(jsonParser, "Can not create a %s instance out of %s", this._valueType.getName(), BeanReader._tokenDesc(jsonParser));
    }

    private final Object _readBean(JSONReader jSONReader, JsonParser jsonParser, Object object) throws JacksonException {
        int n = jsonParser.nextNameMatch(this._propNameMatcher);
        BeanPropertyReader[] beanPropertyReaderArray = this._propValueReaders;
        Object[] objectArray = jSONReader._setterBuffer;
        while (n >= 0) {
            BeanPropertyReader beanPropertyReader = beanPropertyReaderArray[n];
            objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
            beanPropertyReader.setValueFor(object, objectArray);
            n = jsonParser.nextNameMatch(this._propNameMatcher);
            if (n < 0) break;
            beanPropertyReader = beanPropertyReaderArray[n];
            objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
            beanPropertyReader.setValueFor(object, objectArray);
            n = jsonParser.nextNameMatch(this._propNameMatcher);
        }
        if (n != -1) {
            if (n == -2) {
                return this._readWithUnknown(jSONReader, jsonParser, object, jsonParser.currentName());
            }
            throw this._reportProblem(jsonParser);
        }
        return object;
    }

    private Object readRecord(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        String string;
        Object[] objectArray = Arrays.copyOf(this._recordNullValues, this._recordNullValues.length);
        while ((string = jsonParser.nextName()) != null) {
            Object object;
            BeanPropertyReader beanPropertyReader = this.findProperty(string);
            if (beanPropertyReader == null) {
                this.handleUnknown(jSONReader, jsonParser, string);
                continue;
            }
            objectArray[beanPropertyReader.getIndex()] = object = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
        }
        try {
            return this._constructors.createRecord(objectArray);
        }
        catch (Exception exception) {
            return this._reportFailureToCreate(jsonParser, exception);
        }
    }

    private final Object _readWithUnknown(JSONReader jSONReader, JsonParser jsonParser, Object object, String string) throws JacksonException {
        Object[] objectArray = jSONReader._setterBuffer;
        BeanPropertyReader beanPropertyReader = this.findProperty(string);
        if (beanPropertyReader == null) {
            this.handleUnknown(jSONReader, jsonParser, string);
        } else {
            objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
            beanPropertyReader.setValueFor(object, objectArray);
        }
        while ((string = jsonParser.nextName()) != null) {
            beanPropertyReader = this.findProperty(string);
            if (beanPropertyReader == null) {
                this.handleUnknown(jSONReader, jsonParser, string);
                continue;
            }
            objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
            beanPropertyReader.setValueFor(object, objectArray);
        }
        if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
            throw this._reportProblem(jsonParser);
        }
        return object;
    }

    protected void handleUnknown(JSONReader jSONReader, JsonParser jsonParser, String string) throws JacksonException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(jSONReader._features) && !this._ignorableNames.contains(string)) {
            StringBuilder stringBuilder = new StringBuilder(60);
            Iterator<String> iterator = new TreeSet<String>(this._propsByName.keySet()).iterator();
            if (iterator.hasNext()) {
                stringBuilder.append('\"').append(iterator.next()).append('\"');
                while (iterator.hasNext()) {
                    stringBuilder.append(", \"").append(iterator.next()).append('\"');
                }
            }
            throw JSONObjectException.from(jsonParser, "Unrecognized JSON property \"%s\" for Bean type `%s` (known properties: [%s])", string, this._valueType.getName(), stringBuilder.toString());
        }
        jsonParser.nextToken();
        jsonParser.skipChildren();
    }

    private Object nullValue(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz.equals(Integer.TYPE)) {
            return 0;
        }
        if (clazz.equals(Long.TYPE)) {
            return 0L;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (clazz.equals(Double.TYPE)) {
            return 0.0;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (clazz.equals(Short.TYPE)) {
            return (short)0;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (clazz.equals(Byte.TYPE)) {
            return (byte)0;
        }
        throw new IllegalArgumentException("Internal error: Unrecognized primitive value " + clazz.getCanonicalName());
    }

    protected Object _reportFailureToCreate(JsonParser jsonParser, Exception exception) throws JacksonException {
        if (exception instanceof JacksonException) {
            throw (JacksonException)exception;
        }
        throw JSONObjectException.from(jsonParser, exception, "Failed to create an instance of `%s` due to (%s): %s", this._valueType.getName(), exception.getClass().getName(), exception.getMessage());
    }

    protected JacksonException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token %s; should get PROPERTY_NAME or END_OBJECT", jsonParser.currentToken());
    }
}

