/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.util.Collection;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.CollectionBuilder;
import tools.jackson.jr.ob.api.MapBuilder;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.JSONReader;

public class AnyReader
extends ValueReader {
    public static final AnyReader std = new AnyReader();

    public AnyReader() {
        super(Object.class);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 11: {
                    return null;
                }
                case 1: {
                    return this.readFromObject(jSONReader, jsonParser, jSONReader._mapBuilder);
                }
                case 3: {
                    if (jSONReader.arraysAsLists()) {
                        return this.readCollectionFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
                    }
                    return this.readArrayFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
                }
                case 6: {
                    return this.fromString(jsonParser.getString());
                }
                case 7: {
                    JsonParser.NumberType numberType = jsonParser.getNumberType();
                    if (numberType == JsonParser.NumberType.INT) {
                        return jsonParser.getIntValue();
                    }
                    if (numberType == JsonParser.NumberType.LONG) {
                        return jsonParser.getLongValue();
                    }
                    return jsonParser.getBigIntegerValue();
                }
                case 8: {
                    if (!JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS.isEnabled(jSONReader._features)) {
                        JsonParser.NumberType numberType = jsonParser.getNumberType();
                        if (numberType == JsonParser.NumberType.FLOAT) {
                            return Float.valueOf(jsonParser.getFloatValue());
                        }
                        if (numberType == JsonParser.NumberType.DOUBLE) {
                            return jsonParser.getDoubleValue();
                        }
                    }
                    return jsonParser.getDecimalValue();
                }
                case 9: {
                    return this.fromBoolean(true);
                }
                case 10: {
                    return this.fromBoolean(false);
                }
                case 12: {
                    return this.fromEmbedded(jsonParser.getEmbeddedObject());
                }
            }
        }
        throw JSONObjectException.from(jsonParser, "Unexpected value token: " + AnyReader._tokenDesc(jsonParser));
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        switch (jsonParser.currentTokenId()) {
            case 11: {
                return null;
            }
            case 1: {
                return this.readFromObject(jSONReader, jsonParser, jSONReader._mapBuilder);
            }
            case 3: {
                if (jSONReader.arraysAsLists()) {
                    return this.readCollectionFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
                }
                return this.readArrayFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
            }
            case 6: {
                return this.fromString(jsonParser.getString());
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    return jsonParser.getIntValue();
                }
                if (numberType == JsonParser.NumberType.LONG) {
                    return jsonParser.getLongValue();
                }
                return jsonParser.getBigIntegerValue();
            }
            case 8: {
                if (!JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS.isEnabled(jSONReader._features)) {
                    JsonParser.NumberType numberType = jsonParser.getNumberType();
                    if (numberType == JsonParser.NumberType.FLOAT) {
                        return Float.valueOf(jsonParser.getFloatValue());
                    }
                    if (numberType == JsonParser.NumberType.DOUBLE) {
                        return jsonParser.getDoubleValue();
                    }
                }
                return jsonParser.getDecimalValue();
            }
            case 9: {
                return this.fromBoolean(true);
            }
            case 10: {
                return this.fromBoolean(false);
            }
            case 12: {
                return this.fromEmbedded(jsonParser.getEmbeddedObject());
            }
        }
        throw JSONObjectException.from(jsonParser, "Unexpected value token: " + AnyReader._tokenDesc(jsonParser));
    }

    public Map<String, Object> readFromObject(JSONReader jSONReader, JsonParser jsonParser, MapBuilder mapBuilder) throws JacksonException {
        String string = jsonParser.nextName();
        if (string == null) {
            if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                this._reportNotEndObject(jsonParser);
            }
            return mapBuilder.emptyMap();
        }
        String string2 = this.fromKey(string);
        Object object = this.readNext(jSONReader, jsonParser);
        string = jsonParser.nextName();
        if (string == null) {
            if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                this._reportNotEndObject(jsonParser);
            }
            return mapBuilder.singletonMap(string2, object);
        }
        mapBuilder = mapBuilder.start().put(string2, object);
        string2 = this.fromKey(string);
        object = this.readNext(jSONReader, jsonParser);
        try {
            mapBuilder = mapBuilder.put(string2, object);
            while ((string = jsonParser.nextName()) != null) {
                mapBuilder = mapBuilder.put(this.fromKey(string), this.readNext(jSONReader, jsonParser));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
        if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
            this._reportNotEndObject(jsonParser);
        }
        return mapBuilder.build();
    }

    public Object[] readArrayFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws JacksonException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(object);
        }
        try {
            collectionBuilder = collectionBuilder.start().add(object);
            do {
                collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            return collectionBuilder.buildArray();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    public Collection<Object> readCollectionFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws JacksonException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        try {
            collectionBuilder = collectionBuilder.start().add(object);
            do {
                collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            return collectionBuilder.buildCollection();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    private final void _reportNotEndObject(JsonParser jsonParser) throws JacksonException {
        throw JSONObjectException.from(jsonParser, "Unexpected token: %s (should get PROPERTY_NAME or END_OBJECT)", AnyReader._tokenDesc(jsonParser));
    }

    protected Object fromNull() throws JacksonException {
        return null;
    }

    protected Object fromBoolean(boolean bl) throws JacksonException {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String fromKey(String string) throws JacksonException {
        return string;
    }

    protected Object fromString(String string) throws JacksonException {
        return string;
    }

    protected Object fromEmbedded(Object object) throws JacksonException {
        return object;
    }
}

