/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import java.io.Serializable;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.dataformat.yaml.PackageVersion;
import tools.jackson.dataformat.yaml.YAMLFactory;
import tools.jackson.dataformat.yaml.YAMLReadFeature;
import tools.jackson.dataformat.yaml.YAMLWriteFeature;

public class YAMLMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public YAMLMapper() {
        this(new Builder(new YAMLFactory()));
    }

    public YAMLMapper(YAMLFactory f) {
        this(new Builder(f));
    }

    public YAMLMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new YAMLFactory());
    }

    public static Builder builder(YAMLFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static YAMLMapper shared() {
        return SharedWrapper.wrapped();
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + ((Object)((Object)this)).getClass().getName() + "` directly");
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final YAMLFactory tokenStreamFactory() {
        return (YAMLFactory)this._streamFactory;
    }

    public static class Builder
    extends MapperBuilder<YAMLMapper, Builder> {
        public Builder(YAMLFactory f) {
            super((TokenStreamFactory)f);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public YAMLMapper build() {
            return new YAMLMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(YAMLReadFeature ... features) {
            for (YAMLReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(YAMLReadFeature ... features) {
            for (YAMLReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(YAMLReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(YAMLWriteFeature ... features) {
            for (YAMLWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(YAMLWriteFeature ... features) {
            for (YAMLWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(YAMLWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final YAMLMapper MAPPER = YAMLMapper.builder().build();

        private SharedWrapper() {
        }

        public static YAMLMapper wrapped() {
            return MAPPER;
        }
    }
}

