/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.util;

import java.io.Serializable;
import javax.xml.namespace.QName;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.type.ClassKey;
import tools.jackson.databind.util.SimpleLookupCache;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class XmlRootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final transient SimpleLookupCache<ClassKey, QName> _rootNames = new SimpleLookupCache(40, 200);

    protected Object readResolve() {
        if (this._rootNames == null) {
            return new XmlRootNameLookup();
        }
        return this;
    }

    public QName findRootName(DatabindContext ctxt, JavaType rootType) {
        return this.findRootName(ctxt, rootType.getRawClass());
    }

    public QName findRootName(DatabindContext ctxt, Class<?> rootType) {
        ClassKey key = new ClassKey(rootType);
        QName name = (QName)this._rootNames.get((Object)key);
        if (name != null) {
            return name;
        }
        name = this._findRootName(ctxt, rootType);
        this._rootNames.put((Object)key, (Object)name);
        return name;
    }

    protected QName _findRootName(DatabindContext ctxt, Class<?> rootType) {
        AnnotatedClass ac = ctxt.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        String localName = null;
        String ns = null;
        PropertyName root = intr.findRootName(ctxt.getConfig(), ac);
        if (root != null) {
            localName = root.getSimpleName();
            ns = root.getNamespace();
        }
        if (localName == null || localName.length() == 0) {
            localName = StaxUtil.sanitizeXmlTypeName(rootType.getSimpleName());
            return this._qname(ns, localName);
        }
        if (ns == null || ns.isEmpty()) {
            ns = this._findNamespace(ctxt, intr, ac);
        }
        return this._qname(ns, localName);
    }

    private QName _qname(String ns, String localName) {
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, localName);
    }

    private String _findNamespace(DatabindContext ctxt, AnnotationIntrospector ai, AnnotatedClass ann) {
        MapperConfig config = ctxt.getConfig();
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof AnnotationIntrospector.XmlExtensions) || (ns = ((AnnotationIntrospector.XmlExtensions)intr).findNamespace(config, (Annotated)ann)) == null) continue;
            return ns;
        }
        return null;
    }
}

