/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import tools.jackson.core.FormatFeature;

public enum XmlWriteFeature implements FormatFeature
{
    WRITE_XML_DECLARATION(false),
    WRITE_XML_1_1(false),
    WRITE_STANDALONE_YES_TO_XML_DECLARATION(false),
    WRITE_NULLS_AS_XSI_NIL(true),
    UNWRAP_ROOT_OBJECT_NODE(true),
    AUTO_DETECT_XSI_TYPE(true),
    WRITE_XML_SCHEMA_CONFORMING_FLOATS(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (XmlWriteFeature f : XmlWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private XmlWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public int getMask() {
        return this._mask;
    }

    public boolean enabledIn(int flags) {
        return (flags & this.getMask()) != 0;
    }
}

