/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.toml;

import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.UTF8Writer;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.TreeTraversingParser;
import tools.jackson.dataformat.toml.PackageVersion;
import tools.jackson.dataformat.toml.TomlFactoryBuilder;
import tools.jackson.dataformat.toml.TomlGenerator;
import tools.jackson.dataformat.toml.TomlParser;
import tools.jackson.dataformat.toml.TomlReadFeature;
import tools.jackson.dataformat.toml.TomlWriteFeature;
import tools.jackson.dataformat.toml.UTF8Reader;

public final class TomlFactory
extends TextualTSFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_TOML = "toml";
    static final int DEFAULT_TOML_PARSER_FEATURE_FLAGS = TomlReadFeature.collectDefaults();
    static final int DEFAULT_TOML_GENERATOR_FEATURE_FLAGS = TomlWriteFeature.collectDefaults();

    public TomlFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_TOML_PARSER_FEATURE_FLAGS, DEFAULT_TOML_GENERATOR_FEATURE_FLAGS);
    }

    TomlFactory(TomlFactory src) {
        super((TextualTSFactory)src);
    }

    TomlFactory(TomlFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
    }

    public TomlFactoryBuilder rebuild() {
        return new TomlFactoryBuilder(this);
    }

    public static TomlFactoryBuilder builder() {
        return new TomlFactoryBuilder();
    }

    public TomlFactory copy() {
        return new TomlFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new TomlFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_TOML;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return TomlReadFeature.class;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return TomlWriteFeature.class;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    public boolean isEnabled(TomlReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public boolean isEnabled(TomlWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, InputStream in) throws JacksonException {
        boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE);
        return this._createParser(readCtxt, ctxt, UTF8Reader.construct(ctxt, in, autoClose));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, Reader r) throws JacksonException {
        try {
            ObjectNode node = this.parse(readCtxt, ctxt, r);
            TreeTraversingParser treeTraversingParser = new TreeTraversingParser((JsonNode)node, readCtxt);
            return treeTraversingParser;
        }
        finally {
            ctxt.close();
        }
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, byte[] data, int offset, int len) throws JacksonException {
        return this._createParser(readCtxt, ctxt, UTF8Reader.construct(data, offset, len));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, char[] data, int offset, int len, boolean recyclable) throws JacksonException {
        return this._createParser(readCtxt, ctxt, new CharArrayReader(data, offset, len));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, DataInput input) throws JacksonException {
        return (JsonParser)this._unsupported();
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) throws JacksonException {
        return new TomlGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), out);
    }

    protected JsonGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) throws JacksonException {
        return this._createGenerator(writeCtxt, ioCtxt, (Writer)new UTF8Writer(ioCtxt, out));
    }

    protected Writer _createWriter(IOContext ioCtxt, OutputStream out, JsonEncoding enc) throws JacksonException {
        return new UTF8Writer(ioCtxt, out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ObjectNode parse(ObjectReadContext readCtxt, IOContext ctxt, Reader r0) {
        ObjectNode objectNode;
        int readFeatures = readCtxt.getFormatReadFeatures(DEFAULT_TOML_PARSER_FEATURE_FLAGS);
        if (!ctxt.isResourceManaged() && !this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) return TomlParser.parse(this, ctxt, readFeatures, r0);
        Reader r = r0;
        try {
            objectNode = TomlParser.parse(this, ctxt, readFeatures, r);
            if (r == null) return objectNode;
        }
        catch (Throwable throwable) {
            try {
                if (r == null) throw throwable;
                try {
                    r.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        r.close();
        return objectNode;
    }
}

