/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import java.io.IOException;
import java.io.InputStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.dataformat.smile.SmileParser;
import tools.jackson.dataformat.smile.SmileReadFeature;

public class SmileParserBootstrapper {
    protected final IOContext _ioContext;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext ctxt, InputStream in) {
        this._ioContext = ctxt;
        this._in = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._ioContext = ctxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._inputProcessed = -inputStart;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(ObjectReadContext readCtxt, int factoryFeatures, int generalParserFeatures, int smileFeatures, ByteQuadsCanonicalizer rootByteSymbols) throws JacksonException {
        ByteQuadsCanonicalizer can = rootByteSymbols.makeChildOrPlaceholder(factoryFeatures);
        int end = this._inputEnd;
        if (this._inputPtr < end && this._in != null) {
            try {
                int count = this._in.read(this._inputBuffer, end, this._inputBuffer.length - end);
                if (count > 0) {
                    this._inputEnd += count;
                }
            }
            catch (IOException e) {
                throw JacksonIOException.construct((IOException)e);
            }
        }
        SmileParser p = new SmileParser(readCtxt, this._ioContext, generalParserFeatures, smileFeatures, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        boolean hadSig = false;
        if (this._inputPtr >= this._inputEnd) {
            return p;
        }
        byte firstByte = this._inputBuffer[this._inputPtr];
        if (firstByte == 58) {
            hadSig = p.handleSignature(true, true);
        }
        if (!hadSig && SmileReadFeature.REQUIRE_HEADER.enabledIn(smileFeatures)) {
            String msg = firstByte == 123 || firstByte == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") -- rather, it starts with '" + (char)firstByte + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new StreamReadException((JsonParser)p, msg);
        }
        return p;
    }
}

