/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.dataformat.smile.SmileConstants;
import tools.jackson.dataformat.smile.SmileParserBase;
import tools.jackson.dataformat.smile.SmileUtil;

public class SmileParser
extends SmileParserBase {
    private static final boolean JDK11_OR_LATER;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected int _typeAsInt;
    protected boolean _tokenIncomplete = false;

    public SmileParser(ObjectReadContext readCtxt, IOContext ctxt, int parserFeatures, int smileFeatures, ByteQuadsCanonicalizer sym, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(readCtxt, ctxt, parserFeatures, smileFeatures, sym);
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
    }

    protected boolean handleSignature(boolean consumeFirstByte, boolean throwException) throws JacksonException {
        byte b;
        if (consumeFirstByte) {
            ++this._inputPtr;
        }
        if ((b = this._nextByteGuaranteed()) != 41) {
            if (throwException) {
                throw this._constructReadException("Malformed content: signature not valid, starts with 0x3A but followed by 0x%02X, not 0x29", b & 0xFF);
            }
            return false;
        }
        b = this._nextByteGuaranteed();
        if (b != 10) {
            if (throwException) {
                throw this._constructReadException("Malformed content: signature not valid, starts with 0x3A, 0x29, but followed by 0x%02X, not 0xA", b & 0xFF);
            }
            return false;
        }
        byte ch = this._nextByteGuaranteed();
        int versionBits = ch >> 4 & 0xF;
        if (versionBits != 0) {
            throw this._constructReadException("Header version number bits (0x%X) indicate unrecognized version; only 0x0 handled by parser", versionBits);
        }
        if ((ch & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((ch & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (ch & 4) != 0;
        return true;
    }

    public int releaseBuffered(OutputStream out) throws JacksonException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        try {
            out.write(this._inputBuffer, origPtr, count);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return count;
    }

    public Object streamReadInputSource() {
        return this._inputStream;
    }

    private final byte _nextByteGuaranteed() throws JacksonException {
        int ptr = this._inputPtr;
        if (ptr < this._inputEnd) {
            byte b = this._inputBuffer[ptr];
            this._inputPtr = ptr + 1;
            return b;
        }
        this._loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    protected final void _loadMoreGuaranteed() throws JacksonException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final boolean _loadMore() throws JacksonException {
        if (this._inputStream != null) {
            int count;
            try {
                count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            this._currInputProcessed += (long)this._inputEnd;
            this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
            this._inputPtr = 0;
            if (count > 0) {
                this._inputEnd = count;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (count == 0) {
                this._reportBadInputStream(this._inputBuffer.length);
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws JacksonException {
        if (this._inputStream == null) {
            throw this._constructReadException("Needed to read %d bytes, reached end-of-input", minAvailable);
        }
        int missing = this._tryToLoadToHaveAtLeast(minAvailable);
        if (missing > 0) {
            throw this._constructReadException("Needed to read %d bytes, only got %d before end-of-input", minAvailable, minAvailable - missing);
        }
    }

    protected final int _tryToLoadToHaveAtLeast(int minAvailable) throws JacksonException {
        if (this._inputStream == null) {
            return minAvailable;
        }
        int amount = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
        if (amount > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, amount);
            this._inputEnd = amount;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < minAvailable) {
            int count;
            int toRead = this._inputBuffer.length - this._inputEnd;
            try {
                count = this._inputStream.read(this._inputBuffer, this._inputEnd, toRead);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    this._reportBadInputStream(toRead);
                }
                return minAvailable - this._inputEnd;
            }
            this._inputEnd += count;
        }
        return 0;
    }

    @Override
    protected void _closeInput() {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
            }
            this._inputStream = null;
        }
    }

    public boolean hasStringCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        return false;
    }

    @Override
    protected void _releaseBuffers2() {
        byte[] buf;
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
    }

    public JsonToken nextToken() throws JacksonException {
        int ch;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._currToken != JsonToken.PROPERTY_NAME && this._streamReadContext.inObject()) {
            return this._updateToken(this._handlePropertyName());
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextToken();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 5) {
            case 0: {
                if (ch == 0) break;
                return this._handleSharedString(ch - 1);
            }
            case 1: {
                int typeBits = ch & 0x1F;
                if (typeBits < 4) {
                    switch (typeBits) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            return this._updateToken(JsonToken.VALUE_STRING);
                        }
                        case 1: {
                            return this._updateToken(JsonToken.VALUE_NULL);
                        }
                        case 2: {
                            return this._updateToken(JsonToken.VALUE_FALSE);
                        }
                    }
                    return this._updateToken(JsonToken.VALUE_TRUE);
                }
                if (typeBits == 4) {
                    this._finishInt();
                    return this._updateToken(JsonToken.VALUE_NUMBER_INT);
                }
                if (typeBits <= 6) {
                    this._tokenIncomplete = true;
                    return this._updateToken(JsonToken.VALUE_NUMBER_INT);
                }
                if (typeBits < 11 && typeBits != 7) {
                    this._tokenIncomplete = true;
                    return this._updateToken(JsonToken.VALUE_NUMBER_FLOAT);
                }
                if (typeBits != 26) break;
                if (this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this._nextAfterHeader();
                    }
                    return this._updateTokenToNull();
                }
                throw this._constructReadException("Unrecognized token byte 0x3A (malformed segment header?");
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this._seenStringValueCount >= 0) {
                    return this._addSeenStringValue();
                }
                this._tokenIncomplete = true;
                return this._updateToken(JsonToken.VALUE_STRING);
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(ch & 0x1F);
                this._numTypesValid = 1;
                this._numberType = JsonParser.NumberType.INT;
                return this._updateToken(JsonToken.VALUE_NUMBER_INT);
            }
            case 7: {
                switch (ch & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_STRING);
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_EMBEDDED_OBJECT);
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this.createChildArrayContext(-1, -1);
                        return this._updateToken(JsonToken.START_ARRAY);
                    }
                    case 25: {
                        if (!this._streamReadContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._streamReadContext = this._streamReadContext.getParent();
                        return this._updateToken(JsonToken.END_ARRAY);
                    }
                    case 26: {
                        this.createChildObjectContext(-1, -1);
                        return this._updateToken(JsonToken.START_OBJECT);
                    }
                    case 27: {
                        throw this._constructReadException("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_EMBEDDED_OBJECT);
                    }
                    case 31: {
                        return this._updateTokenToNull();
                    }
                }
            }
        }
        return this._reportUnknownValueTypeToken(ch);
    }

    private JsonToken _reportUnknownValueTypeToken(int ch) throws JacksonException {
        throw this._constructReadException("Invalid type marker byte 0x%02X for expected value token", ch & 0xFF);
    }

    private JsonToken _nextAfterHeader() throws JacksonException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 58) {
            return this._updateTokenToNull();
        }
        return this.nextToken();
    }

    private final JsonToken _handleSharedString(int index) throws JacksonException {
        if (index >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(index);
        }
        this._textBuffer.resetWithString(this._seenStringValues[index]);
        return this._updateToken(JsonToken.VALUE_STRING);
    }

    private final JsonToken _addSeenStringValue() throws JacksonException {
        this._finishToken();
        String v = this._textBuffer.contentsAsString();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = v;
        } else {
            this._expandSeenStringValues(v);
        }
        return this._updateToken(JsonToken.VALUE_STRING);
    }

    private final void _expandSeenStringValues(String newText) {
        String[] newShared;
        String[] oldShared = this._seenStringValues;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenStringValueCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        this._seenStringValues = newShared;
        this._seenStringValues[this._seenStringValueCount++] = newText;
    }

    public void finishToken() {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
    }

    public String nextName() throws JacksonException {
        int ch;
        if (this._currToken == JsonToken.PROPERTY_NAME || !this._streamReadContext.inObject()) {
            return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
        }
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._numTypesValid = 0;
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 6) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._streamReadContext.setCurrentName("");
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return "";
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        String name = this._seenNames[index];
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return name;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return this.currentName();
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                String name = this._seenNames[index];
                this._streamReadContext.setCurrentName(name);
                this._updateToken(JsonToken.PROPERTY_NAME);
                return name;
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                String name = this._findOrDecodeShortAsciiName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                this._updateToken(JsonToken.PROPERTY_NAME);
                return name;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    if (!this._streamReadContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._streamReadContext = this._streamReadContext.getParent();
                    this._updateToken(JsonToken.END_OBJECT);
                    return null;
                }
                int len = ch + 2;
                String name = this._findOrDecodeShortUnicodeName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                this._updateToken(JsonToken.PROPERTY_NAME);
                return name;
            }
        }
        throw this._constructReadException("Invalid type marker byte 0x%02X for expected property name (or END_OBJECT marker)", this._typeAsInt);
    }

    public boolean nextName(SerializableString str) throws JacksonException {
        if (this._currToken != JsonToken.PROPERTY_NAME && this._streamReadContext.inObject()) {
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            byte[] nameBytes = str.asQuotedUTF8();
            int byteLen = nameBytes.length;
            if (this._inputPtr + byteLen + 1 < this._inputEnd) {
                int ch;
                int ptr = this._inputPtr;
                this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
                block0 : switch (ch >> 6) {
                    case 0: {
                        switch (ch) {
                            case 32: {
                                this._updateToken(JsonToken.PROPERTY_NAME);
                                this._inputPtr = ptr;
                                this._streamReadContext.setCurrentName("");
                                return byteLen == 0;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: {
                                int index = ((ch & 3) << 8) + (this._inputBuffer[ptr++] & 0xFF);
                                if (index >= this._seenNameCount) {
                                    this._reportInvalidSharedName(index);
                                }
                                String name = this._seenNames[index];
                                this._streamReadContext.setCurrentName(name);
                                this._inputPtr = ptr;
                                this._updateToken(JsonToken.PROPERTY_NAME);
                                return name.equals(str.getValue());
                            }
                        }
                        break;
                    }
                    case 1: {
                        int index = ch & 0x3F;
                        if (index >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        String name = this._seenNames[index];
                        this._streamReadContext.setCurrentName(name);
                        this._inputPtr = ptr;
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return name.equals(str.getValue());
                    }
                    case 2: {
                        int len = 1 + (ch & 0x3F);
                        if (len != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return true;
                    }
                    case 3: {
                        int len = ch & 0x3F;
                        if (len > 55) {
                            if (len != 59) break;
                            this._updateToken(JsonToken.END_OBJECT);
                            this._inputPtr = ptr;
                            this._streamReadContext = this._streamReadContext.getParent();
                            return false;
                        }
                        if ((len += 2) != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return true;
                    }
                }
            }
        }
        return this.nextToken() == JsonToken.PROPERTY_NAME && str.getValue().equals(this.currentName());
    }

    public int nextNameMatch(PropertyNameMatcher matcher) throws JacksonException {
        int ch;
        if (this._currToken == JsonToken.PROPERTY_NAME || !this._streamReadContext.inObject()) {
            this.nextToken();
            return -3;
        }
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._numTypesValid = 0;
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 6) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        this._streamReadContext.setCurrentName("");
                        return matcher.matchName("");
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        String name = this._seenNames[index];
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return matcher.matchName(name);
                    }
                    case 52: {
                        this._handleLongFieldName();
                        this._updateToken(JsonToken.PROPERTY_NAME);
                        return matcher.matchName(this.currentName());
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                String name = this._seenNames[index];
                this._streamReadContext.setCurrentName(name);
                this._updateToken(JsonToken.PROPERTY_NAME);
                return matcher.matchName(name);
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                int match = this._nextNameOptimized(matcher, len);
                if (match >= 0) {
                    this._inputPtr += len;
                    String name = matcher.nameLookup()[match];
                    this._streamReadContext.setCurrentName(name);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._updateToken(JsonToken.PROPERTY_NAME);
                    return match;
                }
                return this._nextNameAsciiDecodeAndAdd(matcher, len);
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    this._streamReadContext = this._streamReadContext.getParent();
                    this._updateToken(JsonToken.END_OBJECT);
                    return -1;
                }
                int len = ch + 2;
                int match = this._nextNameOptimized(matcher, len);
                if (match >= 0) {
                    this._inputPtr += len;
                    String name = matcher.nameLookup()[match];
                    this._streamReadContext.setCurrentName(name);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._updateToken(JsonToken.PROPERTY_NAME);
                    return match;
                }
                return this._nextNameUnicodeDecodeAndAdd(matcher, len);
            }
        }
        throw this._constructReadException("Invalid type marker byte 0x%02X for expected property name (or END_OBJECT marker)", this._typeAsInt);
    }

    private final int _nextNameOptimized(PropertyNameMatcher matcher, int len) throws JacksonException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = inBuf[inPtr] & 0xFF;
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (len > 3) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return matcher.matchByQuad(q);
        }
        byte[] inBuf = this._inputBuffer;
        int inPtr = this._inputPtr;
        int q1 = inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 9) {
            int q2 = inBuf[inPtr++] & 0xFF;
            int left = len - 5;
            if (left > 0) {
                q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return matcher.matchByQuad(q1, q2);
        }
        int q2 = inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 13) {
            int q3 = inBuf[inPtr++] & 0xFF;
            int left = len - 9;
            if (left > 0) {
                q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            this._quad3 = q3;
            return matcher.matchByQuad(q1, q2, q3);
        }
        return this._nextNameFromSymbolsLong(matcher, len, q1, q2);
    }

    private final int _nextNameFromSymbolsLong(PropertyNameMatcher matcher, int len, int q1, int q2) throws JacksonException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, bufLen);
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        int offset = 2;
        int inPtr = this._inputPtr + 8;
        len -= 8;
        byte[] inBuf = this._inputBuffer;
        do {
            q = inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            this._quadBuffer[offset++] = q;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = inBuf[inPtr] & 0xFF;
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return matcher.matchByQuad(this._quadBuffer, offset);
    }

    private int _nextNameAsciiDecodeAndAdd(PropertyNameMatcher matcher, int len) throws JacksonException {
        String name;
        if (this._symbolsCanonical) {
            int qlen = len + 3 >> 2;
            switch (qlen) {
                case 1: {
                    name = this._symbols.findName(this._quad1);
                    break;
                }
                case 2: {
                    name = this._symbols.findName(this._quad1, this._quad2);
                    break;
                }
                case 3: {
                    name = this._symbols.findName(this._quad1, this._quad2, this._quad3);
                    break;
                }
                default: {
                    name = this._symbols.findName(this._quadBuffer, qlen);
                }
            }
            if (name == null) {
                name = this._decodeShortAsciiName(len);
                name = this._addDecodedToSymbols(len, name);
            } else {
                this._inputPtr += len;
            }
        } else {
            name = this._decodeShortAsciiName(len);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._streamReadContext.setCurrentName(name);
        this._updateToken(JsonToken.PROPERTY_NAME);
        return matcher.matchName(name);
    }

    private int _nextNameUnicodeDecodeAndAdd(PropertyNameMatcher matcher, int lenMarker) throws JacksonException {
        String name;
        if (this._symbolsCanonical) {
            switch (lenMarker >> 2) {
                case 0: {
                    name = this._symbols.findName(this._quad1);
                    break;
                }
                case 1: {
                    name = this._symbols.findName(this._quad1, this._quad2);
                    break;
                }
                case 2: {
                    name = this._symbols.findName(this._quad1, this._quad2, this._quad3);
                    break;
                }
                default: {
                    name = this._symbols.findName(this._quadBuffer, lenMarker + 3 >> 2);
                }
            }
            if (name == null) {
                name = this._decodeShortUnicodeName(lenMarker);
                name = this._addDecodedToSymbols(lenMarker, name);
            }
        } else {
            name = this._decodeShortUnicodeName(lenMarker);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._streamReadContext.setCurrentName(name);
        this._updateToken(JsonToken.PROPERTY_NAME);
        return matcher.matchName(name);
    }

    public String nextStringValue() throws JacksonException {
        if (!this._streamReadContext.inObject() || this._currToken == JsonToken.PROPERTY_NAME) {
            int ch;
            int ptr;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((ptr = this._inputPtr) >= this._inputEnd) {
                if (!this._loadMore()) {
                    this._eofAsNextToken();
                    return null;
                }
                ptr = this._inputPtr;
            }
            this._tokenOffsetForTotal = ptr;
            this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
            this._binaryValue = null;
            switch (ch >> 5) {
                case 0: {
                    if (ch != 0) {
                        if (--ch >= this._seenStringValueCount) {
                            this._reportInvalidSharedStringValue(ch);
                        }
                        this._inputPtr = ptr;
                        String text = this._seenStringValues[ch];
                        this._textBuffer.resetWithString(text);
                        this._updateToken(JsonToken.VALUE_STRING);
                        return text;
                    }
                    throw this._constructReadException("Invalid token byte 0x00");
                }
                case 1: {
                    int typeBits = ch & 0x1F;
                    if (typeBits != 0) break;
                    this._inputPtr = ptr;
                    this._textBuffer.resetWithEmpty();
                    this._updateToken(JsonToken.VALUE_STRING);
                    return "";
                }
                case 2: 
                case 3: {
                    this._updateToken(JsonToken.VALUE_STRING);
                    this._inputPtr = ptr;
                    String text = this._decodeShortAsciiValue(1 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 4: 
                case 5: {
                    this._updateToken(JsonToken.VALUE_STRING);
                    this._inputPtr = ptr;
                    String text = this._decodeShortUnicodeValue(2 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 6: {
                    break;
                }
            }
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getString() : null;
    }

    public int nextIntValue(int defaultValue) throws JacksonException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return defaultValue;
    }

    public long nextLongValue(long defaultValue) throws JacksonException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return defaultValue;
    }

    public Boolean nextBooleanValue() throws JacksonException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String getString() throws JacksonException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.PROPERTY_NAME) {
            return this._streamReadContext.currentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getStringCharacters() throws JacksonException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.PROPERTY_NAME) {
                return this._streamReadContext.currentName().toCharArray();
            }
            if (this._currToken.isNumeric()) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getStringLength() throws JacksonException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            if (this._currToken == JsonToken.PROPERTY_NAME) {
                return this._streamReadContext.currentName().length();
            }
            if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return this.getNumberValue().toString().length();
            }
            char[] ch = this._currToken.asCharArray();
            if (ch != null) {
                return ch.length;
            }
        }
        return 0;
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public String getValueAsString() throws JacksonException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getString();
    }

    public String getValueAsString(String defaultValue) throws JacksonException {
        if (this._currToken != JsonToken.VALUE_STRING) {
            if (this._currToken == JsonToken.PROPERTY_NAME) {
                return this.currentName();
            }
            if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
                return defaultValue;
            }
        }
        return this.getString();
    }

    public int getString(Writer writer) throws JacksonException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        JsonToken t = this._currToken;
        try {
            if (t == JsonToken.VALUE_STRING) {
                return this._textBuffer.contentsToWriter(writer);
            }
            if (t == JsonToken.PROPERTY_NAME) {
                String n = this._streamReadContext.currentName();
                writer.write(n);
                return n.length();
            }
            if (t != null) {
                if (t.isNumeric()) {
                    return this._textBuffer.contentsToWriter(writer);
                }
                char[] ch = t.asCharArray();
                writer.write(ch);
                return ch.length;
            }
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
        } else {
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._getBinaryFromString(b64variant);
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", this.currentToken());
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws JacksonException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws JacksonException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._currToken == JsonToken.VALUE_STRING) {
                byte[] b = this._getBinaryFromString(b64variant);
                int len = b.length;
                try {
                    out.write(b, 0, len);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                return len;
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", this.currentToken());
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int len = this._binaryValue.length;
            try {
                out.write(this._binaryValue, 0, len);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            return len;
        }
        if (this._typeAsInt == 253) {
            int totalCount;
            int count;
            for (int left = totalCount = this._readUnsignedVInt(); left > 0; left -= count) {
                int avail = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    avail = this._inputEnd - this._inputPtr;
                }
                count = Math.min(avail, left);
                try {
                    out.write(this._inputBuffer, this._inputPtr, count);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                this._inputPtr += count;
            }
            this._tokenIncomplete = false;
            return totalCount;
        }
        if (this._typeAsInt != 232) {
            this._throwInternal();
        }
        int totalCount = this._readUnsignedVInt();
        byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(out, totalCount, encodingBuffer);
        }
        finally {
            this._ioContext.releaseBase64Buffer(encodingBuffer);
        }
        this._tokenIncomplete = false;
        return totalCount;
    }

    private void _readBinaryEncoded(OutputStream out, int length, byte[] buffer) throws JacksonException {
        int outPtr = 0;
        int lastSafeOut = buffer.length - 7;
        while (length > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            buffer[outPtr++] = (byte)((i1 += x >> 3) >> 24);
            buffer[outPtr++] = (byte)(i1 >> 16);
            buffer[outPtr++] = (byte)(i1 >> 8);
            buffer[outPtr++] = (byte)i1;
            buffer[outPtr++] = (byte)(i2 >> 16);
            buffer[outPtr++] = (byte)(i2 >> 8);
            buffer[outPtr++] = (byte)i2;
            length -= 7;
            if (outPtr <= lastSafeOut) continue;
            try {
                out.write(buffer, 0, outPtr);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            outPtr = 0;
        }
        if (length > 0) {
            if (this._inputEnd - this._inputPtr < length + 1) {
                this._loadToHaveAtLeast(length + 1);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < length; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                buffer[outPtr++] = (byte)(value >> 7 - i);
            }
            buffer[outPtr++] = (byte)((value <<= length) + this._inputBuffer[this._inputPtr++]);
        }
        if (outPtr > 0) {
            try {
                out.write(buffer, 0, outPtr);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    private final byte[] _getBinaryFromString(Base64Variant variant) throws JacksonException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._binaryValue == null) {
            ByteArrayBuilder builder = new ByteArrayBuilder();
            this._decodeBase64(this.getString(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    protected final JsonToken _handlePropertyName() throws JacksonException {
        int ch;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 6) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._streamReadContext.setCurrentName("");
                        return JsonToken.PROPERTY_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        this._streamReadContext.setCurrentName(this._seenNames[index]);
                        return JsonToken.PROPERTY_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.PROPERTY_NAME;
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                this._streamReadContext.setCurrentName(this._seenNames[index]);
                return JsonToken.PROPERTY_NAME;
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                String name = this._findOrDecodeShortAsciiName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                return JsonToken.PROPERTY_NAME;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    if (!this._streamReadContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._streamReadContext = this._streamReadContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int len = ch + 2;
                String name = this._findOrDecodeShortUnicodeName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                return JsonToken.PROPERTY_NAME;
            }
        }
        throw this._constructReadException("Invalid type marker byte 0x%02X for expected property name (or END_OBJECT marker)", this._typeAsInt);
    }

    private String _findOrDecodeShortAsciiName(int len) throws JacksonException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (this._symbolsCanonical) {
            String name = this._findDecodedFromSymbols(len);
            if (name != null) {
                this._inputPtr += len;
            } else {
                name = this._decodeShortAsciiName(len);
                name = this._addDecodedToSymbols(len, name);
            }
            return name;
        }
        return this._decodeShortAsciiName(len);
    }

    private String _findOrDecodeShortUnicodeName(int len) throws JacksonException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (this._symbolsCanonical) {
            String name = this._findDecodedFromSymbols(len);
            if (name != null) {
                this._inputPtr += len;
            } else {
                name = this._decodeShortUnicodeName(len);
                name = this._addDecodedToSymbols(len, name);
            }
            return name;
        }
        return this._decodeShortUnicodeName(len);
    }

    private final String[] _expandSeenNames(String[] oldShared) {
        String[] newShared;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenNameCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        return newShared;
    }

    private final String _addDecodedToSymbols(int len, String name) {
        if (len < 5) {
            return this._symbols.addName(name, this._quad1);
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2);
        }
        if (len < 13) {
            return this._symbols.addName(name, this._quad1, this._quad2, this._quad3);
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen);
    }

    private final String _decodeShortAsciiName(int len) throws JacksonException {
        int inPtr;
        if (JDK11_OR_LATER) {
            int inPtr2 = this._inputPtr;
            this._inputPtr = inPtr2 + len;
            String str = new String(this._inputBuffer, inPtr2, len, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(str);
            return str;
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int inEnd = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < inEnd; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    private final String _decodeShortUnicodeName(int len) throws JacksonException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                if (inPtr + code > end) {
                    int firstCharOffset = len - (end - inPtr) - 1;
                    this._reportTruncatedUTF8InName(len, firstCharOffset, i, code);
                }
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._inputPtr = inPtr;
                        throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", i);
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._inputPtr += len;
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final String _decodeLongUnicodeName(int[] quads, int byteLen, int quadLen, boolean addToSymbolTable) throws JacksonException {
        int lastQuad;
        int lastQuadBytes = byteLen & 3;
        if (lastQuadBytes > 0) {
            lastQuad = quads[quadLen - 1];
            quads[quadLen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this._textBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this._reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this._reportInvalidEOF(" in long property name", JsonToken.PROPERTY_NAME);
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this._textBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this._textBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes > 0) {
            quads[quadLen - 1] = lastQuad;
        }
        if (addToSymbolTable) {
            return this._symbols.addName(baseName, quads, quadLen);
        }
        return baseName;
    }

    private final String _handleLongFieldName() throws JacksonException {
        String name;
        byte[] inBuf = this._inputBuffer;
        int quads = 0;
        int bytes = 0;
        int q = 0;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 0;
                break;
            }
            q = b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 1;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 2;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 3;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
        }
        int byteLen = quads << 2;
        if (bytes > 0) {
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            q = SmileParser._padLastQuad(q, bytes);
            this._quadBuffer[quads++] = q;
            byteLen += bytes;
        }
        String string = name = this._symbolsCanonical ? this._symbols.findName(this._quadBuffer, quads) : null;
        if (name == null) {
            name = this._decodeLongUnicodeName(this._quadBuffer, byteLen, quads, this._symbolsCanonical);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._streamReadContext.setCurrentName(name);
        return name;
    }

    private final String _findDecodedFromSymbols(int len) throws JacksonException {
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = SmileParser._padQuadForNulls(inBuf[inPtr]);
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (len > 3) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        byte[] inBuf = this._inputBuffer;
        int inPtr = this._inputPtr;
        int q1 = inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 9) {
            int q2 = SmileParser._padQuadForNulls(inBuf[inPtr++]);
            int left = len - 5;
            if (left > 0) {
                q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        int q2 = inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 13) {
            int q3 = SmileParser._padQuadForNulls(inBuf[inPtr++]);
            int left = len - 9;
            if (left > 0) {
                q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            this._quad3 = q3;
            return this._symbols.findName(q1, q2, q3);
        }
        return this._findDecodedFixed12(len, q1, q2);
    }

    private final String _findDecodedFixed12(int len, int q1, int q2) throws JacksonException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, bufLen);
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        int offset = 2;
        int inPtr = this._inputPtr + 8;
        len -= 8;
        byte[] inBuf = this._inputBuffer;
        do {
            q = inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            this._quadBuffer[offset++] = q;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = SmileParser._padQuadForNulls(inBuf[inPtr]);
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    private static int[] _growArrayTo(int[] arr, int minSize) {
        int size = minSize + 4;
        if (arr == null) {
            return new int[size];
        }
        return Arrays.copyOf(arr, size);
    }

    private static final int _padLastQuad(int q, int bytes) {
        return bytes == 4 ? q : q | -1 << (bytes << 3);
    }

    private static final int _padQuadForNulls(int firstByte) {
        return firstByte & 0xFF | 0xFFFFFF00;
    }

    @Override
    protected void _parseNumericValue() throws JacksonException {
        if (!this._tokenIncomplete) {
            throw this._constructReadException("Internal error: number token (%s) decoded, no value set", this._currToken);
        }
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        if (tb >> 5 != 1) {
            throw this._constructReadException("Current token (%s) not numeric, can not use numeric value accessors", this._currToken);
        }
        this._finishNumberToken(tb);
    }

    protected final void _finishToken() throws JacksonException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        int type = tb >> 5;
        if (type == 1) {
            this._finishNumberToken(tb);
            return;
        }
        if (type <= 3) {
            this._decodeShortAsciiValue(1 + (tb & 0x3F));
            return;
        }
        if (type <= 5) {
            this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            return;
        }
        if (type == 7) {
            switch ((tb &= 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAsciiValue();
                    return;
                }
                case 1: {
                    this._decodeLongUnicodeValue();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._binaryValue = this._finishBinaryRaw();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int tb) throws JacksonException {
        switch (tb & 0x1F) {
            case 4: {
                this._finishInt();
                return;
            }
            case 5: {
                this._finishLong();
                return;
            }
            case 6: {
                this._finishBigInteger();
                return;
            }
            case 8: {
                this._finishFloat();
                return;
            }
            case 9: {
                this._finishDouble();
                return;
            }
            case 10: {
                this._finishBigDecimal();
                return;
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() throws JacksonException {
        int value;
        this._numTypesValid = 1;
        this._numberType = JsonParser.NumberType.INT;
        int ptr = this._inputPtr;
        if (ptr + 5 >= this._inputEnd) {
            this._finishIntSlow();
            return;
        }
        if ((value = this._inputBuffer[ptr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if ((i = this._inputBuffer[ptr++]) >= 0) {
                value = (value << 7) + i;
                if ((i = this._inputBuffer[ptr++]) >= 0) {
                    value = (value << 7) + i;
                    if ((i = this._inputBuffer[ptr++]) >= 0) {
                        value = (value << 7) + i;
                        if ((i = this._inputBuffer[ptr++]) >= 0) {
                            throw this._constructReadException("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._inputPtr = ptr;
        this._numberInt = SmileUtil.zigzagDecode(value);
    }

    private final void _finishIntSlow() throws JacksonException {
        int value;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                value = (value << 7) + i;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                    value = (value << 7) + i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                        value = (value << 7) + i;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                            throw this._constructReadException("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(value);
    }

    private final void _finishLong() throws JacksonException {
        this._numTypesValid = 2;
        this._numberType = JsonParser.NumberType.LONG;
        int ptr = this._inputPtr;
        int maxEnd = ptr + 11;
        if (maxEnd >= this._inputEnd) {
            this._finishLongSlow();
            return;
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        long l = i;
        do {
            byte value;
            if ((value = this._inputBuffer[ptr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._inputPtr = ptr;
                this._numberLong = SmileUtil.zigzagDecode(l);
                return;
            }
            l = (l << 7) + (long)value;
        } while (ptr < maxEnd);
        throw this._constructReadException("Corrupt input; 64-bit VInt extends beyond 11 data bytes");
    }

    private final void _finishLongSlow() throws JacksonException {
        long l = this._fourBytesToInt();
        while (true) {
            byte value;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l);
                return;
            }
            l = (l << 7) + (long)value;
        }
    }

    private final int _fourBytesToInt() throws JacksonException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._fourBytesToIntSlow();
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        this._inputPtr = ptr;
        return i;
    }

    private final int _fourBytesToIntSlow() throws JacksonException {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        int i = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return (i << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigInteger() throws JacksonException {
        byte[] raw = this._read7BitBinaryWithLength();
        if (raw.length == 0) {
            this._numberBigInt = BigInteger.ZERO;
        } else {
            this._streamReadConstraints.validateIntegerLength(raw.length);
            this._numberBigInt = new BigInteger(raw);
        }
        this._numTypesValid = 4;
        this._numberType = JsonParser.NumberType.BIG_INTEGER;
    }

    private final void _finishFloat() throws JacksonException {
        float f;
        int i = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        this._numberFloat = f = Float.intBitsToFloat(i);
        this._numberType = JsonParser.NumberType.FLOAT;
        this._numTypesValid = 32;
    }

    private final void _finishDouble() throws JacksonException {
        long hi = this._fourBytesToInt();
        long value = (hi << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(value);
        this._numberType = JsonParser.NumberType.DOUBLE;
        this._numTypesValid = 8;
    }

    private final void _finishBigDecimal() throws JacksonException {
        int scale = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] raw = this._read7BitBinaryWithLength();
        if (raw.length == 0) {
            this._numberBigDecimal = BigDecimal.ZERO;
        } else {
            this._streamReadConstraints.validateFPLength(raw.length);
            BigInteger unscaledValue = new BigInteger(raw);
            this._numberBigDecimal = new BigDecimal(unscaledValue, scale);
        }
        this._numTypesValid = 16;
        this._numberType = JsonParser.NumberType.BIG_DECIMAL;
    }

    protected final int _readUnsignedVInt() throws JacksonException {
        int ch;
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._readUnsignedVIntSlow();
        }
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return ch & 0x3F;
        }
        int value = ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) >= 0 || value >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(value >>> 21, ch);
        }
        return (value << 6) + (ch & 0x3F);
    }

    protected final int _readUnsignedVIntSlow() throws JacksonException {
        byte ch;
        int value = 0;
        int count = 0;
        do {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
                value = (value << 6) + (ch & 0x3F);
                return value;
            }
            value = (value << 7) + ch;
        } while (++count < 4);
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((ch = this._inputBuffer[this._inputPtr++]) >= 0 || value >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(value >>> 21, ch);
        }
        return (value << 6) + (ch & 0x3F);
    }

    protected final void _reportInvalidUnsignedVInt(int firstCh, int lastCh) throws JacksonException {
        if (lastCh >= 0) {
            throw this._constructReadException("Overflow in VInt (current token %s): 5th byte (0x%2X) of 5-byte sequence must have its highest bit set to indicate end", this.currentToken(), lastCh);
        }
        throw this._constructReadException("Overflow in VInt (current token %s): 1st byte (0x%2X) of 5-byte sequence must have its top 4 bits zeroes", this.currentToken(), firstCh);
    }

    protected final String _decodeShortAsciiValue(int len) throws JacksonException {
        int inPtr;
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (JDK11_OR_LATER) {
            int inPtr2 = this._inputPtr;
            this._inputPtr = inPtr2 + len;
            String str = new String(this._inputBuffer, inPtr2, len, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(str);
            return str;
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < end; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    protected final String _decodeShortUnicodeValue(int byteLen) throws JacksonException {
        if (this._inputEnd - this._inputPtr < byteLen) {
            this._loadToHaveAtLeast(byteLen);
        }
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        this._inputPtr += byteLen;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + byteLen;
        while (inPtr < end) {
            int i;
            if ((i = inputBuf[inPtr++]) >= 0) {
                outBuf[outPtr++] = (char)i;
                continue;
            }
            int unitLen = codes[i &= 0xFF];
            if (inPtr + unitLen > end) {
                int firstCharOffset = byteLen - (end - inPtr) - 1;
                return this._reportTruncatedUTF8InString(byteLen, firstCharOffset, i, unitLen);
            }
            switch (unitLen) {
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", i);
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _decodeLongAsciiValue() throws JacksonException {
        int inPtr;
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            inPtr = this._inputPtr;
            int left = this._inputEnd - inPtr;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            left = Math.min(left, outBuf.length - outPtr);
            do {
                byte b;
                if ((b = this._inputBuffer[inPtr++]) == -4) break block0;
                outBuf[outPtr++] = (char)b;
            } while (--left > 0);
            this._inputPtr = inPtr;
        }
        this._inputPtr = inPtr;
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _decodeLongUnicodeValue() throws JacksonException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block14: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 252) break;
            switch (codes[c]) {
                case 1: {
                    c = this._decodeUtf8_2(c);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        c = this._decodeUtf8_3fast(c);
                        break;
                    }
                    c = this._decodeUtf8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUtf8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidInitial(c);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final byte[] _finishBinaryRaw() throws JacksonException {
        int byteLen = this._readUnsignedVInt();
        if (byteLen > 250000) {
            return this._finishBinaryRawLong(byteLen);
        }
        int expLen = byteLen;
        byte[] b = new byte[byteLen];
        int ptr = 0;
        while (byteLen > 0) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportIncompleteBinaryReadRaw(expLen, ptr);
            }
            int toAdd = Math.min(byteLen, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, b, ptr, toAdd);
            this._inputPtr += toAdd;
            ptr += toAdd;
            byteLen -= toAdd;
        }
        return b;
    }

    protected byte[] _finishBinaryRawLong(int expLen) throws JacksonException {
        try (ByteArrayBuilder bb = new ByteArrayBuilder(125000);){
            int count;
            for (int left = expLen; left > 0; left -= count) {
                int avail = this._inputEnd - this._inputPtr;
                if (avail <= 0) {
                    if (!this._loadMore()) {
                        this._reportIncompleteBinaryReadRaw(expLen, expLen - left);
                    }
                    avail = this._inputEnd - this._inputPtr;
                }
                count = Math.min(avail, left);
                bb.write(this._inputBuffer, this._inputPtr, count);
                this._inputPtr += count;
            }
            byte[] byArray = bb.toByteArray();
            return byArray;
        }
    }

    private final byte[] _read7BitBinaryWithLength() throws JacksonException {
        int byteLen = this._readUnsignedVInt();
        if (byteLen > 250000) {
            return this._finishBinary7BitLong(byteLen);
        }
        byte[] result = new byte[byteLen];
        int lastOkPtr = byteLen - 7;
        int ptr = 0;
        while (ptr <= lastOkPtr) {
            int missing;
            if (this._inputEnd - this._inputPtr < 8 && (missing = this._tryToLoadToHaveAtLeast(8)) > 0) {
                this._reportIncompleteBinaryRead7Bit(byteLen, ptr);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            result[ptr++] = (byte)((i1 += x >> 3) >> 24);
            result[ptr++] = (byte)(i1 >> 16);
            result[ptr++] = (byte)(i1 >> 8);
            result[ptr++] = (byte)i1;
            result[ptr++] = (byte)(i2 >> 16);
            result[ptr++] = (byte)(i2 >> 8);
            result[ptr++] = (byte)i2;
        }
        int toDecode = result.length - ptr;
        if (toDecode > 0) {
            int missing;
            if (this._inputEnd - this._inputPtr < toDecode + 1 && (missing = this._tryToLoadToHaveAtLeast(toDecode + 1)) > 0) {
                this._reportIncompleteBinaryRead7Bit(byteLen, ptr);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < toDecode; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                result[ptr++] = (byte)(value >> 7 - i);
            }
            result[ptr] = (byte)((value <<= toDecode) + this._inputBuffer[this._inputPtr++]);
        }
        return result;
    }

    protected byte[] _finishBinary7BitLong(int expLen) throws JacksonException {
        try (ByteArrayBuilder bb = new ByteArrayBuilder(125000);){
            int left;
            byte[] buffer = new byte[896];
            int bufPtr = 0;
            for (left = expLen; left >= 7; left -= 7) {
                int missing;
                if (this._inputEnd - this._inputPtr < 8 && (missing = this._tryToLoadToHaveAtLeast(8)) > 0) {
                    this._reportIncompleteBinaryRead7Bit(expLen, bb.size() + bufPtr);
                }
                int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
                byte x = this._inputBuffer[this._inputPtr++];
                int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
                buffer[bufPtr++] = (byte)((i1 += x >> 3) >> 24);
                buffer[bufPtr++] = (byte)(i1 >> 16);
                buffer[bufPtr++] = (byte)(i1 >> 8);
                buffer[bufPtr++] = (byte)i1;
                buffer[bufPtr++] = (byte)(i2 >> 16);
                buffer[bufPtr++] = (byte)(i2 >> 8);
                buffer[bufPtr++] = (byte)i2;
                if (bufPtr < buffer.length) continue;
                bb.write(buffer, 0, bufPtr);
                bufPtr = 0;
            }
            if (left > 0) {
                if (this._inputEnd - this._inputPtr < left + 1) {
                    this._loadToHaveAtLeast(left + 1);
                }
                int value = this._inputBuffer[this._inputPtr++];
                for (int i = 1; i < left; ++i) {
                    value = (value << 7) + this._inputBuffer[this._inputPtr++];
                    buffer[bufPtr++] = (byte)(value >> 7 - i);
                }
                buffer[bufPtr++] = (byte)((value <<= left) + this._inputBuffer[this._inputPtr++]);
            }
            if (bufPtr > 0) {
                bb.write(buffer, 0, bufPtr);
            }
            byte[] byArray = bb.toByteArray();
            return byArray;
        }
    }

    protected void _skipIncomplete() throws JacksonException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        switch (tb >> 5) {
            case 1: {
                switch ((tb &= 0x1F) >> 2) {
                    case 1: {
                        switch (tb & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    int end = this._inputEnd;
                                    byte[] buf = this._inputBuffer;
                                    while (this._inputPtr < end) {
                                        if (buf[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this._loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (tb & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (tb & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (tb & 0x3F));
                return;
            }
            case 7: {
                switch ((tb &= 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            int end = this._inputEnd;
                            byte[] buf = this._inputBuffer;
                            while (this._inputPtr < end) {
                                if (buf[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this._loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int len) throws JacksonException {
        if (len < 0) {
            throw this._constructReadException("Internal error: _skipBytes() called with negative value: %d", len);
        }
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this._loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() throws JacksonException {
        int origBytes = this._readUnsignedVInt();
        int chunks = origBytes / 7;
        int encBytes = chunks * 8;
        if (encBytes < 0) {
            throw this._constructReadException("Invalid content: invalid 7-bit binary encoded byte length (0x%X) exceeds maximum valid value", origBytes);
        }
        if ((origBytes -= 7 * chunks) > 0) {
            encBytes += 1 + origBytes;
        }
        this._skipBytes(encBytes);
    }

    private final int _decodeUtf8_2(int c) throws JacksonException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int _decodeUtf8_3(int c1) throws JacksonException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_3fast(int c1) throws JacksonException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_4(int c) throws JacksonException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int index) throws StreamReadException {
        if (this._seenNames == null) {
            throw this._constructReadException("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        throw this._constructReadException("Invalid shared name reference %d; only got %d names in buffer (invalid content)", index, this._seenNameCount);
    }

    protected void _reportInvalidSharedStringValue(int index) throws StreamReadException {
        if (this._seenStringValues == null) {
            throw this._constructReadException("Encountered shared text value reference, even though document header did not declare shared text value references may be included");
        }
        throw this._constructReadException("Invalid shared text value reference %d; only got %s names in buffer (invalid content)", index, this._seenStringValueCount);
    }

    protected void _reportInvalidInitial(int mask) throws StreamReadException {
        throw this._constructReadException("Invalid UTF-8 start byte 0x02X", mask);
    }

    protected void _reportInvalidOther(int mask, int ptr) throws StreamReadException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    protected void _reportInvalidOther(int mask) throws StreamReadException {
        throw this._constructReadException("Invalid UTF-8 middle byte 0x%02X", mask);
    }

    protected void _reportIncompleteBinaryReadRaw(int expLen, int actLen) throws StreamReadException {
        this._reportInvalidEOF(String.format(" for Binary value (raw): expected %d bytes, only found %d", expLen, actLen), this.currentToken());
    }

    protected void _reportIncompleteBinaryRead7Bit(int expLen, int actLen) throws StreamReadException {
        long encodedLen = (7L + 8L * (long)expLen) / 7L;
        this._reportInvalidEOF(String.format(" for Binary value (7-bit): expected %d payload bytes (from %d encoded), only decoded %d", expLen, encodedLen, actLen), this.currentToken());
    }

    protected String _reportTruncatedUTF8InString(int strLenBytes, int truncatedCharOffset, int firstUTFByteValue, int bytesExpected) throws StreamReadException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode String value (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", strLenBytes, firstUTFByteValue, truncatedCharOffset, bytesExpected));
    }

    protected String _reportTruncatedUTF8InName(int strLenBytes, int truncatedCharOffset, int firstUTFByteValue, int bytesExpected) throws StreamReadException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode Name (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", strLenBytes, firstUTFByteValue, truncatedCharOffset, bytesExpected));
    }

    private final JsonToken _eofAsNextToken() throws JacksonException {
        if (!this._streamReadContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        return this._updateTokenToNull();
    }

    private void createChildArrayContext(int lineNr, int colNr) throws JacksonException {
        this._streamReadContext = this._streamReadContext.createChildArrayContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    private void createChildObjectContext(int lineNr, int colNr) throws JacksonException {
        this._streamReadContext = this._streamReadContext.createChildObjectContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    static {
        boolean recentJdk;
        try {
            String.class.getMethod("strip", new Class[0]);
            recentJdk = true;
        }
        catch (Exception e) {
            recentJdk = false;
        }
        JDK11_OR_LATER = recentJdk;
    }
}

