/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import java.io.Serializable;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.dataformat.smile.PackageVersion;
import tools.jackson.dataformat.smile.SmileFactory;
import tools.jackson.dataformat.smile.SmileReadFeature;
import tools.jackson.dataformat.smile.SmileWriteFeature;

public class SmileMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public SmileMapper() {
        this(new SmileFactory());
    }

    public SmileMapper(SmileFactory f) {
        this(new Builder(f));
    }

    public SmileMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new SmileFactory());
    }

    public static Builder builder(SmileFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static SmileMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public SmileFactory tokenStreamFactory() {
        return (SmileFactory)this._streamFactory;
    }

    public static class Builder
    extends MapperBuilder<SmileMapper, Builder> {
        public Builder(SmileFactory f) {
            super((TokenStreamFactory)f);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public SmileMapper build() {
            return new SmileMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(SmileReadFeature ... features) {
            for (SmileReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(SmileReadFeature ... features) {
            for (SmileReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(SmileReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(SmileWriteFeature ... features) {
            for (SmileWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(SmileWriteFeature ... features) {
            for (SmileWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(SmileWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final SmileMapper MAPPER = SmileMapper.builder().build();

        private SharedWrapper() {
        }

        public static SmileMapper wrapped() {
            return MAPPER;
        }
    }
}

