/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schemagen;

import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.TypeElement;
import java.util.Set;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.dataformat.protobuf.schemagen.DefaultTagGenerator;
import tools.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import tools.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;

public class EnumElementVisitor
extends JsonStringFormatVisitor.Base
implements TypeElementBuilder {
    EnumElement.Builder _builder;
    DefaultTagGenerator _tagGenerator = new DefaultTagGenerator(0);

    public EnumElementVisitor(SerializationContext provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        if (!type.isEnumType()) {
            throw new IllegalArgumentException("Expected an enum, however given type is " + String.valueOf(type));
        }
        this._builder = EnumElement.builder();
        this._builder.name(type.getRawClass().getSimpleName());
        this._builder.documentation("Enum for " + type.toCanonical());
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public void enumTypes(Set<String> enums) {
        for (String eName : enums) {
            this._builder.addConstant(this.buildEnumConstant(eName));
        }
    }

    protected EnumConstantElement buildEnumConstant(String name) {
        EnumConstantElement.Builder builder = EnumConstantElement.builder();
        builder.name(name);
        builder.tag(this._tagGenerator.nextTag());
        return builder.build();
    }
}

