/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Objects;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.protobuf.ByteAccumulator;
import tools.jackson.dataformat.protobuf.PackageVersion;
import tools.jackson.dataformat.protobuf.ProtobufUtil;
import tools.jackson.dataformat.protobuf.ProtobufWriteContext;
import tools.jackson.dataformat.protobuf.schema.FieldType;
import tools.jackson.dataformat.protobuf.schema.ProtobufField;
import tools.jackson.dataformat.protobuf.schema.ProtobufMessage;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;

public class ProtobufGenerator
extends GeneratorBase {
    protected static final ProtobufField UNKNOWN_FIELD = ProtobufField.unknownField();
    protected static final ProtobufMessage UNKNOWN_MESSAGE = ProtobufMessage.bogusMessage("<unknown>");
    protected final ProtobufSchema _schema;
    protected ProtobufWriteContext _rootContext;
    protected boolean _inObject;
    protected boolean _writeTag;
    protected boolean _complete;
    protected ProtobufMessage _currMessage;
    protected ProtobufField _currField;
    protected final OutputStream _output;
    protected ByteAccumulator _buffered;
    protected ProtobufWriteContext _streamWriteContext;
    protected byte[] _currBuffer;
    protected byte[] _origCurrBuffer;
    protected int _currStart;
    protected int _currPtr;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public ProtobufGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, ProtobufSchema schema, OutputStream output) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._output = output;
        this._streamWriteContext = this._rootContext = ProtobufWriteContext.createNullContext();
        this._origCurrBuffer = ioCtxt.allocWriteEncodingBuffer();
        this._currBuffer = this._origCurrBuffer;
        this._schema = Objects.requireNonNull(schema, "Can not pass `null` 'schema'");
        this._streamWriteContext = this._rootContext = ProtobufWriteContext.createRootContext(schema.getRootType());
    }

    public final Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public final void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public final TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_BINARY_WRITE_CAPABILITIES;
    }

    public Object streamWriteOutputTarget() {
        return this._output;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public ProtobufSchema getSchema() {
        return this._schema;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        ProtobufField f;
        if (!this._inObject) {
            this._reportError("Cannot write a property name: current context not Object but " + this._streamWriteContext.typeDesc());
        }
        if ((f = this._currField) != null && this._streamWriteContext.notArray()) {
            if ((f = f.nextIf(name)) == null) {
                f = this._currMessage.field(name);
            }
        } else {
            f = this._currMessage.firstIf(name);
        }
        if (f == null) {
            if (this._currMessage == UNKNOWN_MESSAGE || this.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
                f = UNKNOWN_FIELD;
            } else {
                this._reportError("Unrecognized field '" + name + "' (in Message of type " + this._currMessage.getName() + "); known fields are: " + this._currMessage.fieldsAsString());
            }
        }
        this._streamWriteContext.setField(f);
        this._currField = f;
        return this;
    }

    public JsonGenerator writeName(SerializableString sstr) throws JacksonException {
        if (!this._inObject) {
            this._reportError("Cannot write a property name: current context not Object but " + this._streamWriteContext.typeDesc());
        }
        ProtobufField f = this._currField;
        String name = sstr.getValue();
        if (f != null && this._streamWriteContext.notArray()) {
            if ((f = f.nextIf(name)) == null) {
                f = this._currMessage.field(name);
            }
        } else {
            f = this._currMessage.firstIf(name);
        }
        if (f == null) {
            if (this._currMessage == UNKNOWN_MESSAGE || this.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
                f = UNKNOWN_FIELD;
            } else {
                this._reportError("Unrecognized field '" + name + "' (in Message of type " + this._currMessage.getName() + "); known fields are: " + this._currMessage.fieldsAsString());
            }
        }
        this._streamWriteContext.setField(f);
        this._currField = f;
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        String idStr = Long.valueOf(id).toString();
        return this.writeName(idStr);
    }

    public final void flush() throws JacksonException {
        try {
            int start;
            int len;
            if (this._buffered == null && (len = this._currPtr - (start = this._currStart)) > 0) {
                this._currStart = 0;
                this._currPtr = 0;
                this._output.write(this._currBuffer, start, len);
            }
            if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._output.flush();
            }
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected void _closeInput() throws IOException {
        if (this.isEnabled(StreamWriteFeature.AUTO_CLOSE_CONTENT)) {
            ProtobufWriteContext ctxt;
            while ((ctxt = this._streamWriteContext) != null) {
                if (ctxt.inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        if (!this._complete) {
            this._complete();
        }
        if (this._output != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._output.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._output.flush();
            }
        }
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        if (!this._inObject) {
            this._reportError("Current context not an OBJECT, can not write arrays");
        }
        if (this._currField == null) {
            return (JsonGenerator)this._reportError("Can not write START_ARRAY without field (message type " + this._currMessage.getName() + ")");
        }
        if (!this._currField.isArray()) {
            this._reportError("Can not write START_ARRAY: field '" + this._currField.name + "' not declared as 'repeated'");
        }
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext();
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        boolean bl = this._writeTag = !this._currField.packed;
        if (!this._writeTag) {
            this._startBuffering(this._currField.typedTag);
        }
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this.writeStartArray();
        this._streamWriteContext.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._streamWriteContext.inRoot()) {
            if (!this._complete) {
                this._complete();
            }
            this._inObject = false;
        } else {
            this._inObject = this._streamWriteContext.inObject();
        }
        this._writeTag = true;
        if (this._currField.packed) {
            this._finishBuffering();
        }
        return this;
    }

    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        this.writeStartObject();
        this._streamWriteContext.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        if (this._currField == null) {
            if (!this._streamWriteContext.inRoot()) {
                this._reportError("Can not write START_OBJECT without field (message type " + this._currMessage.getName() + ")");
            }
            this._currMessage = this._schema.getRootType();
        } else {
            if (!this._currField.isObject) {
                this._reportError("Can not write START_OBJECT: type of field '" + this._currField.name + "' not Message but: " + String.valueOf((Object)this._currField.type));
            }
            this._currMessage = this._currField.getMessageType();
            if (this._writeTag) {
                this._startBuffering(this._currField.typedTag);
            } else {
                this._startBuffering();
            }
        }
        if (this._inObject) {
            this._streamWriteContext = this._streamWriteContext.createChildObjectContext(this._currMessage);
            this._currField = null;
        } else {
            this._streamWriteContext = this._streamWriteContext.createChildObjectContext(this._currMessage);
            this._inObject = true;
        }
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        this._writeTag = true;
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        boolean inObj;
        if (!this._inObject) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._streamWriteContext.inRoot()) {
            if (!this._complete) {
                this._complete();
            }
        } else {
            this._currMessage = this._streamWriteContext.getMessageType();
        }
        this._currField = this._streamWriteContext.getField();
        this._inObject = inObj = this._streamWriteContext.inObject();
        boolean bl = this._writeTag = inObj || !this._streamWriteContext.inArray() || !this._currField.packed;
        if (this._buffered != null) {
            this._finishBuffering();
        }
        return this;
    }

    public JsonGenerator writeArray(int[] array, int offset, int length) throws JacksonException {
        this._verifyArrayWrite(array);
        this._verifyOffsets(array.length, offset, length);
        if (length > 0) {
            int end = offset + length;
            if (this._currField.packed) {
                this._writePackedArray(array, offset, end);
            } else {
                this._writeNonPackedArray(array, offset, end);
            }
            this._writeTag = true;
        }
        return this;
    }

    public JsonGenerator writeArray(long[] array, int offset, int length) throws JacksonException {
        this._verifyArrayWrite(array);
        this._verifyOffsets(array.length, offset, length);
        if (length > 0) {
            int end = offset + length;
            if (this._currField.packed) {
                this._writePackedArray(array, offset, end);
            } else {
                this._writeNonPackedArray(array, offset, end);
            }
            this._writeTag = true;
        }
        return this;
    }

    public JsonGenerator writeArray(double[] array, int offset, int length) throws JacksonException {
        this._verifyArrayWrite(array);
        this._verifyOffsets(array.length, offset, length);
        if (length > 0) {
            int end = offset + length;
            if (this._currField.packed) {
                this._writePackedArray(array, offset, end);
            } else {
                this._writeNonPackedArray(array, offset, end);
            }
            this._writeTag = true;
        }
        return this;
    }

    private void _verifyArrayWrite(Object array) throws JacksonException {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        if (!this._inObject) {
            this._reportError("Current context not an OBJECT, can not write arrays");
        }
        if (this._currField == null) {
            this._reportError("Can not write START_ARRAY without field (message type " + this._currMessage.getName() + ")");
            return;
        }
        if (!this._currField.isArray()) {
            this._reportError("Can not write START_ARRAY: field '" + this._currField.name + "' not declared as 'repeated'");
        }
    }

    private void _writePackedArray(int[] array, int i, int end) throws JacksonException {
        this._startBuffering(this._currField.typedTag);
        int type = this._currField.wireType;
        if (type == 0) {
            boolean zigzag = this._currField.usesZigZag;
            while (i < end) {
                int v = array[i];
                if (zigzag) {
                    v = ProtobufUtil.zigzagEncode(v);
                }
                this._writeVIntNoTag(v);
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                this._writeInt32NoTag(array[i]);
                ++i;
            }
        } else if (type == 1) {
            while (i < end) {
                this._writeInt64NoTag(array[i]);
                ++i;
            }
        } else {
            this._reportWrongWireType("int");
        }
        this._finishBuffering();
    }

    private void _writePackedArray(long[] array, int i, int end) throws JacksonException {
        this._startBuffering(this._currField.typedTag);
        int type = this._currField.wireType;
        if (type == 0) {
            boolean zigzag = this._currField.usesZigZag;
            while (i < end) {
                long v = array[i];
                if (zigzag) {
                    v = ProtobufUtil.zigzagEncode(v);
                }
                this._writeVLongNoTag(v);
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                this._writeInt32NoTag((int)array[i]);
                ++i;
            }
        } else if (type == 1) {
            while (i < end) {
                this._writeInt64NoTag(array[i]);
                ++i;
            }
        } else {
            this._reportWrongWireType("int");
        }
        this._finishBuffering();
    }

    private void _writePackedArray(double[] array, int i, int end) throws JacksonException {
        this._startBuffering(this._currField.typedTag);
        int type = this._currField.wireType;
        if (type == 1) {
            while (i < end) {
                this._writeInt64NoTag(Double.doubleToLongBits(array[i]));
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                float f = (float)array[i];
                this._writeInt32NoTag(Float.floatToRawIntBits(f));
                ++i;
            }
        } else {
            this._reportWrongWireType("double");
        }
        this._finishBuffering();
    }

    private void _writeNonPackedArray(int[] array, int i, int end) throws JacksonException {
        int type = this._currField.wireType;
        if (type == 0) {
            boolean zigzag = this._currField.usesZigZag;
            while (i < end) {
                int v = array[i];
                if (zigzag) {
                    v = ProtobufUtil.zigzagEncode(v);
                }
                this._writeVInt(v);
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                this._writeInt32(array[i]);
                ++i;
            }
        } else if (type == 1) {
            while (i < end) {
                this._writeInt64(array[i]);
                ++i;
            }
        } else {
            this._reportWrongWireType("int");
        }
    }

    private void _writeNonPackedArray(long[] array, int i, int end) throws JacksonException {
        int type = this._currField.wireType;
        if (type == 0) {
            boolean zigzag = this._currField.usesZigZag;
            while (i < end) {
                long v = array[i];
                if (zigzag) {
                    v = ProtobufUtil.zigzagEncode(v);
                }
                this._writeVLong(v);
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                this._writeInt32((int)array[i]);
                ++i;
            }
        } else if (type == 1) {
            while (i < end) {
                this._writeInt64(array[i]);
                ++i;
            }
        } else {
            this._reportWrongWireType("int");
        }
    }

    private void _writeNonPackedArray(double[] array, int i, int end) throws JacksonException {
        int type = this._currField.wireType;
        if (type == 1) {
            while (i < end) {
                this._writeInt64(Double.doubleToLongBits(array[i]));
                ++i;
            }
        } else if (type == 5) {
            while (i < end) {
                float f = (float)array[i];
                this._writeInt32(Float.floatToRawIntBits(f));
                ++i;
            }
        } else {
            this._reportWrongWireType("double");
        }
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        int c;
        int ptr;
        if (text == null) {
            return this.writeNull();
        }
        if (this._currField.wireType != 2) {
            this._writeEnum(text);
            return this;
        }
        int clen = text.length();
        if (clen > 99) {
            this._encodeLongerString(text);
            return this;
        }
        if (clen == 0) {
            this._writeEmptyString();
            return this;
        }
        this._verifyValueWrite();
        this._ensureRoom(clen + clen + clen + 7);
        int start = ptr = this._writeTag(this._currPtr) + 1;
        byte[] buf = this._currBuffer;
        int i = 0;
        while ((c = text.charAt(i)) <= 127) {
            buf[ptr++] = (byte)c;
            if (++i < clen) continue;
            buf[start - 1] = (byte)(ptr - start);
            this._currPtr = ptr;
            return this;
        }
        while (i < clen) {
            if ((c = text.charAt(i++)) <= 127) {
                buf[ptr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[ptr++] = (byte)(0xC0 | c >> 6);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                buf[ptr++] = (byte)(0xE0 | c >> 12);
                buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (i >= clen) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._decodeSurrogate(c, text.charAt(i++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            buf[ptr++] = (byte)(0xF0 | c >> 18);
            buf[ptr++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c & 0x3F);
        }
        int blen = ptr - start;
        if (blen <= 127) {
            buf[start - 1] = (byte)blen;
        } else {
            System.arraycopy(buf, start, buf, start + 1, blen);
            buf[start - 1] = (byte)(128 + (blen & 0x7F));
            buf[start] = (byte)(blen >> 7);
            ++ptr;
        }
        this._currPtr = ptr;
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int clen) throws JacksonException {
        int c;
        int ptr;
        if (text == null) {
            return this.writeNull();
        }
        if (this._currField.wireType != 2) {
            this._writeEnum(new String(text, offset, clen));
        }
        if (clen > 99) {
            this._encodeLongerString(text, offset, clen);
            return this;
        }
        if (clen == 0) {
            this._writeEmptyString();
            return this;
        }
        this._verifyValueWrite();
        this._ensureRoom(clen + clen + clen + 7);
        int start = ptr = this._writeTag(this._currPtr) + 1;
        byte[] buf = this._currBuffer;
        int end = offset + clen;
        while ((c = text[offset]) <= 127) {
            buf[ptr++] = (byte)c;
            if (++offset < end) continue;
            buf[start - 1] = (byte)(ptr - start);
            this._currPtr = ptr;
            return this;
        }
        while (offset < end) {
            if ((c = text[offset++]) <= 127) {
                buf[ptr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                buf[ptr++] = (byte)(0xC0 | c >> 6);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                buf[ptr++] = (byte)(0xE0 | c >> 12);
                buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[ptr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (offset >= end) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._decodeSurrogate(c, text[offset++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            buf[ptr++] = (byte)(0xF0 | c >> 18);
            buf[ptr++] = (byte)(0x80 | c >> 12 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c >> 6 & 0x3F);
            buf[ptr++] = (byte)(0x80 | c & 0x3F);
        }
        int blen = ptr - start;
        if (blen <= 127) {
            buf[start - 1] = (byte)blen;
        } else {
            System.arraycopy(buf, start, buf, start + 1, blen);
            buf[start - 1] = (byte)(128 + (blen & 0x7F));
            buf[start] = (byte)(blen >> 7);
            ++ptr;
        }
        this._currPtr = ptr;
        return this;
    }

    public JsonGenerator writeString(SerializableString sstr) throws JacksonException {
        this._verifyValueWrite();
        if (this._currField.wireType == 2) {
            byte[] b = sstr.asUnquotedUTF8();
            this._writeLengthPrefixed(b, 0, b.length);
        } else if (this._currField.type == FieldType.ENUM) {
            int index = this._currField.findEnumIndex(sstr);
            if (index < 0) {
                this._reportEnumError(sstr);
            }
            this._writeEnum(index);
        } else {
            this._reportWrongWireType("string");
        }
        return this;
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("string");
            return this;
        }
        this._verifyValueWrite();
        this._writeLengthPrefixed(text, offset, len);
        return this;
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("string");
            return this;
        }
        this._verifyValueWrite();
        this._writeLengthPrefixed(text, offset, len);
        return this;
    }

    protected void _writeEmptyString() throws JacksonException {
        this._verifyValueWrite();
        this._ensureRoom(6);
        this._currPtr = this._writeTag(this._currPtr);
        this._currBuffer[this._currPtr++] = 0;
    }

    protected void _writeEnum(String str) throws JacksonException {
        int index;
        if (this._currField.type != FieldType.ENUM) {
            this._reportWrongWireType("string");
        }
        if ((index = this._currField.findEnumIndex(str)) < 0) {
            this._reportEnumError(str);
        }
        int tag = this._currField.typedTag;
        int ptr = this._currPtr;
        if (index > 127 || tag > 127 || ptr + 1 >= this._currBuffer.length) {
            this._writeVInt(index);
            return;
        }
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)tag;
        buf[ptr++] = (byte)index;
        this._currPtr = ptr;
    }

    protected void _writeEnum(int index) throws JacksonException {
        int tag = this._currField.typedTag;
        int ptr = this._currPtr;
        if (index > 127 || tag > 127 || ptr + 1 >= this._currBuffer.length) {
            this._writeVInt(index);
            return;
        }
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)tag;
        buf[ptr++] = (byte)index;
        this._currPtr = ptr;
    }

    protected void _reportEnumError(Object enumValue) throws JacksonException {
        this._reportErrorF("No Enum '%s' found for property '%s'; valid values = %s" + String.valueOf(this._currField.getEnumValues()), this._currField.name, enumValue);
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        this._verifyValueWrite();
        if (this._currField.wireType != 2) {
            this._reportWrongWireType("binary");
            return this;
        }
        this._ensureRoom(10);
        this._writeLengthPrefixed(data, offset, len);
        return this;
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            int b = this._currField.usesZigZag ? (state ? 2 : 0) : (state ? 1 : 0);
            this._writeVInt(b);
            return this;
        }
        if (type == 5) {
            this._writeInt32(state ? 1 : 0);
            return this;
        }
        if (type == 1) {
            this._writeInt64(state ? 1L : 0L);
            return this;
        }
        this._reportWrongWireType("boolean");
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite();
        if (this._currField == UNKNOWN_FIELD) {
            return this;
        }
        if (this._currField.required) {
            this._reportError("Can not omit writing of `null` value for required field '" + this._currField.name + "' (type " + String.valueOf((Object)this._currField.type) + ")");
        }
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int v) throws JacksonException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            if (this._currField.usesZigZag) {
                v = ProtobufUtil.zigzagEncode(v);
            }
            this._writeVInt(v);
            return this;
        }
        if (type == 5) {
            this._writeInt32(v);
            return this;
        }
        if (type == 1) {
            this._writeInt64(v);
            return this;
        }
        this._reportWrongWireType("int");
        return this;
    }

    public JsonGenerator writeNumber(long v) throws JacksonException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 0) {
            if (this._currField.usesZigZag) {
                v = ProtobufUtil.zigzagEncode(v);
            }
            this._writeVLong(v);
            return this;
        }
        if (type == 5) {
            this._writeInt32((int)v);
            return this;
        }
        if (type == 1) {
            this._writeInt64(v);
            return this;
        }
        this._reportWrongWireType("long");
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        if (this._currField == UNKNOWN_FIELD) {
            return this;
        }
        this.writeNumber(v.longValue());
        return this;
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 5) {
            float f = (float)d;
            this._writeInt32(Float.floatToRawIntBits(f));
            return this;
        }
        if (type == 1) {
            this._writeInt64(Double.doubleToLongBits(d));
            return this;
        }
        if (this._currField.type == FieldType.STRING) {
            this._encodeLongerString(String.valueOf(d));
            return this;
        }
        this._reportWrongWireType("double");
        return this;
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        this._verifyValueWrite();
        int type = this._currField.wireType;
        if (type == 5) {
            this._writeInt32(Float.floatToRawIntBits(f));
            return this;
        }
        if (type == 1) {
            this._writeInt64(Double.doubleToLongBits(f));
            return this;
        }
        if (this._currField.type == FieldType.STRING) {
            this._encodeLongerString(String.valueOf(f));
            return this;
        }
        this._reportWrongWireType("float");
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        if (this._currField == UNKNOWN_FIELD) {
            return this;
        }
        this.writeNumber(v.doubleValue());
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        throw new UnsupportedOperationException("Can not write 'untyped' numbers");
    }

    protected final void _verifyValueWrite() throws JacksonException {
        if (this._currField == null) {
            this._reportError("Can not write value without indicating field first (in message of type " + this._currMessage.getName() + ")");
        }
    }

    protected void _verifyValueWrite(String typeMsg) throws JacksonException {
        this._throwInternal();
    }

    protected void _releaseBuffers() {
        byte[] b = this._currBuffer;
        if (b != null) {
            this._currBuffer = null;
            byte[] b2 = this._origCurrBuffer;
            byte[] toRelease = b == b2 || b.length > b2.length ? b : b2;
            this._ioContext.releaseWriteEncodingBuffer(toRelease);
        }
    }

    protected void _encodeLongerString(char[] text, int offset, int clen) throws JacksonException {
        this._verifyValueWrite();
        byte[] b = new String(text, offset, clen).getBytes(UTF8);
        this._writeLengthPrefixed(b, 0, b.length);
    }

    protected void _encodeLongerString(String text) throws JacksonException {
        byte[] b = text.getBytes(UTF8);
        this._writeLengthPrefixed(b, 0, b.length);
    }

    protected void _writeLengthPrefixed(byte[] data, int offset, int len) throws JacksonException {
        this._ensureRoom(10);
        int ptr = this._writeTag(this._currPtr);
        ptr = ProtobufUtil.appendLengthLength(len, this._currBuffer, ptr);
        while (len > 0) {
            int max = Math.min(len, this._currBuffer.length - ptr);
            System.arraycopy(data, offset, this._currBuffer, ptr, max);
            ptr += max;
            if ((len -= max) == 0) {
                this._currPtr = ptr;
                break;
            }
            offset += max;
            ByteAccumulator acc = this._buffered;
            int start = this._currStart;
            this._currStart = 0;
            int toFlush = ptr - start;
            ptr = 0;
            if (acc == null) {
                if (toFlush > 0) {
                    try {
                        this._output.write(this._currBuffer, start, toFlush);
                    }
                    catch (IOException e) {
                        throw this._wrapIOFailure(e);
                    }
                }
                ptr = 0;
                continue;
            }
            if (toFlush > 0) {
                acc.append(this._currBuffer, start, toFlush);
            }
            this._currBuffer = ProtobufUtil.allocSecondary(this._currBuffer);
        }
    }

    private final void _writeVInt(int v) throws JacksonException {
        this._ensureRoom(10);
        int ptr = this._writeTag(this._currPtr);
        if (v < 0) {
            this._currPtr = this._writeVIntMax(v, ptr);
            return;
        }
        byte[] buf = this._currBuffer;
        if (v <= 127) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)(128 + (v & 0x7F));
            if ((v >>= 7) <= 127) {
                buf[ptr++] = (byte)v;
            } else {
                buf[ptr++] = (byte)((v & 0x7F) + 128);
                if ((v >>= 7) <= 127) {
                    buf[ptr++] = (byte)v;
                } else {
                    buf[ptr++] = (byte)((v & 0x7F) + 128);
                    if ((v >>= 7) <= 127) {
                        buf[ptr++] = (byte)v;
                    } else {
                        buf[ptr++] = (byte)((v & 0x7F) + 128);
                        buf[ptr++] = (byte)((v >>= 7) & 0x7F);
                    }
                }
            }
        }
        this._currPtr = ptr;
    }

    private final void _writeVIntNoTag(int v) throws JacksonException {
        this._ensureRoom(5);
        int ptr = this._currPtr;
        if (v < 0) {
            this._currPtr = this._writeVIntMax(v, ptr);
            return;
        }
        byte[] buf = this._currBuffer;
        if (v <= 127) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)(128 + (v & 0x7F));
            if ((v >>= 7) <= 127) {
                buf[ptr++] = (byte)v;
            } else {
                buf[ptr++] = (byte)((v & 0x7F) + 128);
                if ((v >>= 7) <= 127) {
                    buf[ptr++] = (byte)v;
                } else {
                    buf[ptr++] = (byte)((v & 0x7F) + 128);
                    if ((v >>= 7) <= 127) {
                        buf[ptr++] = (byte)v;
                    } else {
                        buf[ptr++] = (byte)((v & 0x7F) + 128);
                        buf[ptr++] = (byte)((v >>= 7) & 0x7F);
                    }
                }
            }
        }
        this._currPtr = ptr;
    }

    private final int _writeVIntMax(int v, int ptr) throws JacksonException {
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)((v & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((v >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(v >>= 7);
        return ptr;
    }

    private final void _writeVLong(long v) throws JacksonException {
        this._ensureRoom(16);
        int ptr = this._writeTag(this._currPtr);
        if (v < 0L) {
            this._currPtr = this._writeVLongMax(v, ptr);
            return;
        }
        if (v <= 0xFFFFFFFL) {
            int i = (int)v;
            byte[] buf = this._currBuffer;
            if (v <= 127L) {
                buf[ptr++] = (byte)v;
            } else {
                do {
                    buf[ptr++] = (byte)((i & 0x7F) + 128);
                } while ((i >>= 7) > 127);
                buf[ptr++] = (byte)i;
            }
            this._currPtr = ptr;
            return;
        }
        int i = (int)v;
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        if ((v >>>= 28) <= 127L) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)((v & 0x7FL) + 128L);
            i = (int)(v >> 7);
            do {
                buf[ptr++] = (byte)((i & 0x7F) + 128);
            } while ((i >>= 7) > 127);
            buf[ptr++] = (byte)i;
        }
        this._currPtr = ptr;
    }

    private final void _writeVLongNoTag(long v) throws JacksonException {
        this._ensureRoom(10);
        int ptr = this._currPtr;
        if (v < 0L) {
            this._currPtr = this._writeVLongMax(v, ptr);
            return;
        }
        if (v <= 0xFFFFFFFL) {
            int i = (int)v;
            byte[] buf = this._currBuffer;
            if (v <= 127L) {
                buf[ptr++] = (byte)v;
            } else {
                do {
                    buf[ptr++] = (byte)((i & 0x7F) + 128);
                } while ((i >>= 7) > 127);
                buf[ptr++] = (byte)i;
            }
            this._currPtr = ptr;
            return;
        }
        int i = (int)v;
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        if ((v >>>= 28) <= 127L) {
            buf[ptr++] = (byte)v;
        } else {
            buf[ptr++] = (byte)((v & 0x7FL) + 128L);
            i = (int)(v >> 7);
            do {
                buf[ptr++] = (byte)((i & 0x7F) + 128);
            } while ((i >>= 7) > 127);
            buf[ptr++] = (byte)i;
        }
        this._currPtr = ptr;
    }

    private final int _writeVLongMax(long v, int ptr) throws JacksonException {
        byte[] buf = this._currBuffer;
        int i = (int)v;
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        i = (int)(v >>> 28);
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        buf[ptr++] = (byte)(((i >>= 7) & 0x7F) + 128);
        i = (int)(v >>> 56);
        buf[ptr++] = (byte)((i & 0x7F) + 128);
        buf[ptr++] = (byte)(i >>= 7);
        return ptr;
    }

    private final void _writeInt32(int v) throws JacksonException {
        this._ensureRoom(9);
        int ptr = this._writeTag(this._currPtr);
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final void _writeInt32NoTag(int v) throws JacksonException {
        this._ensureRoom(4);
        int ptr = this._currPtr;
        byte[] buf = this._currBuffer;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final void _writeInt64(long v64) throws JacksonException {
        this._ensureRoom(13);
        int ptr = this._writeTag(this._currPtr);
        byte[] buf = this._currBuffer;
        int v = (int)v64;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        v = (int)(v64 >> 32);
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final void _writeInt64NoTag(long v64) throws JacksonException {
        this._ensureRoom(8);
        int ptr = this._currPtr;
        byte[] buf = this._currBuffer;
        int v = (int)v64;
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        v = (int)(v64 >> 32);
        buf[ptr++] = (byte)v;
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        buf[ptr++] = (byte)(v >>= 8);
        this._currPtr = ptr;
    }

    private final int _writeTag(int ptr) {
        if (this._writeTag) {
            byte[] buf = this._currBuffer;
            int tag = this._currField.typedTag;
            if (tag <= 127) {
                buf[ptr++] = (byte)tag;
            } else {
                do {
                    buf[ptr++] = (byte)((tag & 0x7F) + 128);
                } while ((tag >>= 7) > 127);
                buf[ptr++] = (byte)tag;
            }
        }
        return ptr;
    }

    private final void _startBuffering(int typedTag) throws JacksonException {
        int len;
        this._ensureRoom(20);
        int ptr = this._currPtr;
        int start = this._currStart;
        if (this._buffered == null && (len = ptr - start) > 0) {
            start = 0;
            ptr = 0;
            try {
                this._output.write(this._currBuffer, start, len);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        this._buffered = new ByteAccumulator(this._buffered, typedTag, this._currBuffer, ptr, this._currStart);
        this._currStart = ptr += 10;
        this._currPtr = ptr;
    }

    private final void _startBuffering() throws JacksonException {
        this._ensureRoom(16);
        int ptr = this._currPtr;
        this._buffered = new ByteAccumulator(this._buffered, -1, this._currBuffer, ptr, this._currStart);
        this._currStart = ptr += 5;
        this._currPtr = ptr;
    }

    private final void _finishBuffering() throws JacksonException {
        int start = this._currStart;
        int newStart = this._currPtr;
        int currLen = newStart - start;
        ByteAccumulator acc = this._buffered;
        try {
            acc = acc.finish(this._output, this._currBuffer, start, currLen);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        this._buffered = acc;
        if (acc == null) {
            this._currStart = 0;
            this._currPtr = 0;
            return;
        }
        this._currStart = newStart;
    }

    protected final void _ensureRoom(int needed) throws JacksonException {
        if (this._currPtr + needed > this._currBuffer.length) {
            this._ensureMore();
        }
    }

    protected final void _ensureMore() throws JacksonException {
        int start = this._currStart;
        int currLen = this._currPtr - start;
        this._currStart = 0;
        this._currPtr = 0;
        ByteAccumulator acc = this._buffered;
        if (acc == null) {
            if (currLen > 0) {
                try {
                    this._output.write(this._currBuffer, start, currLen);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
            }
            return;
        }
        if (currLen > 0) {
            acc.append(this._currBuffer, start, currLen);
        }
        this._currBuffer = ProtobufUtil.allocSecondary(this._currBuffer);
    }

    protected void _complete() throws JacksonException {
        this._complete = true;
        int start = this._currStart;
        int currLen = this._currPtr - start;
        this._currPtr = start;
        ByteAccumulator acc = this._buffered;
        try {
            if (acc == null) {
                if (currLen > 0) {
                    this._output.write(this._currBuffer, start, currLen);
                    this._currStart = 0;
                    this._currPtr = 0;
                }
            } else {
                for (acc = acc.finish(this._output, this._currBuffer, start, currLen); acc != null; acc = acc.finish(this._output, this._currBuffer)) {
                }
                this._buffered = null;
            }
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected void _reportWrongWireType(String typeStr) throws JacksonException {
        if (this._currField == UNKNOWN_FIELD) {
            return;
        }
        this._reportErrorF("Can not write `string` value for '%s' (type %s)", new Object[]{this._currField.name, this._currField.type});
    }

    private void _reportErrorF(String format, Object ... args) throws JacksonException {
        this._reportError(String.format(format, args));
    }

    private void _throwIllegalSurrogate(int code) {
        if (code > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (code >= 55296) {
            if (code <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output");
    }
}

