/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schema;

import com.squareup.protoparser.DataType;
import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.OptionElement;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.TypeElement;
import java.util.EnumMap;
import java.util.Map;
import tools.jackson.dataformat.protobuf.schema.NativeProtobufSchema;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;

public class FileDescriptorSet {
    protected FileDescriptorProto[] file;

    protected FileDescriptorSet() {
    }

    public FileDescriptorSet(FileDescriptorProto[] f) {
        this.file = f;
    }

    public FileDescriptorProto[] getFile() {
        return this.file;
    }

    public FileDescriptorProto findDescriptor(String fileName) {
        for (FileDescriptorProto fdp : this.file) {
            if (!fdp.name.equals(fileName)) continue;
            return fdp;
        }
        return null;
    }

    public FileDescriptorProto getDescriptor(String fileName) {
        FileDescriptorProto p = this.findDescriptor(fileName);
        if (p == null) {
            throw new IllegalArgumentException(fileName + " not found");
        }
        return p;
    }

    public ProtobufSchema schemaForFirstType() {
        ProtoFile protoFile = this.buildProtoFile(this.file[0].name);
        return NativeProtobufSchema.construct(protoFile).forFirstType();
    }

    public ProtobufSchema schemaFor(String rootTypeName) {
        for (FileDescriptorProto fdp : this.file) {
            for (DescriptorProto dp : fdp.message_type) {
                if (!dp.name.equals(rootTypeName)) continue;
                ProtoFile protoFile = this.buildProtoFile(fdp.name);
                NativeProtobufSchema nps = NativeProtobufSchema.construct(protoFile);
                return nps.forType(rootTypeName);
            }
        }
        throw new IllegalArgumentException(rootTypeName + " not found");
    }

    private ProtoFile buildProtoFile(String fileName) {
        FileDescriptorProto fdp = this.getDescriptor(fileName);
        ProtoFile.Builder builder = ProtoFile.builder((String)fdp.name);
        builder.syntax(fdp.getSyntax());
        builder.packageName(fdp.getPackage());
        if (fdp.dependency != null) {
            for (String dependency : fdp.dependency) {
                FileDescriptorProto dep = this.getDescriptor(dependency);
                for (DescriptorProto dp : dep.message_type) {
                    MessageElement me = dp.buildMessageElement();
                    builder.addType((TypeElement)me);
                }
            }
        }
        for (DescriptorProto dp : fdp.message_type) {
            MessageElement me = dp.buildMessageElement();
            builder.addType((TypeElement)me);
        }
        return builder.build();
    }

    public static class FileDescriptorProto {
        public String name;
        protected String _package;
        public String[] dependency;
        public int[] public_dependency;
        public int[] weak_dependency;
        public DescriptorProto[] message_type;
        public EnumDescriptorProto[] enum_type;
        public ServiceDescriptorProto[] service;
        public FieldDescriptorProto[] extension;
        public FileOptions options;
        public SourceCodeInfo source_code_info;
        public String syntax;

        public ProtoFile.Syntax getSyntax() {
            if (this.syntax == null) {
                return ProtoFile.Syntax.PROTO_2;
            }
            return ProtoFile.Syntax.valueOf((String)this.syntax);
        }

        public void setPackage(String p) {
            this._package = p;
        }

        public String getPackage() {
            return this._package;
        }
    }

    public static class DescriptorProto {
        public String name;
        public FieldDescriptorProto[] field;
        public FieldDescriptorProto[] extension;
        public DescriptorProto[] nested_type;
        public EnumDescriptorProto[] enum_type;
        public ExtensionRange[] extension_range;
        public OneofDescriptorProto[] oneof_decl;
        public MessageOptions options;
        public ReservedRange[] reserved_range;
        public String[] reserved_name;

        public MessageElement buildMessageElement() {
            MessageElement.Builder messageElementBuilder = MessageElement.builder();
            messageElementBuilder.name(this.name);
            if (this.field != null) {
                for (FieldDescriptorProto f : this.field) {
                    OptionElement option;
                    OptionElement.Kind kind;
                    DataType dataType;
                    String fieldName = f.name;
                    FieldDescriptorProto.Type type = f.type;
                    FieldElement.Label label = f.getLabel();
                    if (type.equals((Object)FieldDescriptorProto.Type.TYPE_MESSAGE) || type.equals((Object)FieldDescriptorProto.Type.TYPE_ENUM)) {
                        String fullyQualifiedtypeName = f.type_name;
                        String typeName = fullyQualifiedtypeName.substring(fullyQualifiedtypeName.indexOf(".", 2) + 1);
                        dataType = DataType.NamedType.create((String)typeName);
                    } else {
                        dataType = f.getDataType();
                    }
                    FieldElement.Builder fieldBuilder = FieldElement.builder().name(fieldName).type(dataType).label(label).tag(f.number);
                    if (f.json_name != null) {
                        kind = OptionElement.Kind.STRING;
                        option = OptionElement.create((String)"json_name", (OptionElement.Kind)kind, (Object)f.json_name);
                        fieldBuilder.addOption(option);
                    }
                    if (f.options != null && f.options.packed) {
                        kind = OptionElement.Kind.STRING;
                        option = OptionElement.create((String)"packed", (OptionElement.Kind)kind, (Object)"true");
                        fieldBuilder.addOption(option);
                    }
                    messageElementBuilder.addField(fieldBuilder.build());
                }
            }
            if (this.nested_type != null) {
                for (DescriptorProto n : this.nested_type) {
                    messageElementBuilder.addType((TypeElement)n.buildMessageElement());
                }
            }
            if (this.enum_type != null) {
                for (EnumDescriptorProto e : this.enum_type) {
                    EnumElement.Builder nestedEnumElement = EnumElement.builder().name(e.name);
                    for (EnumValueDescriptorProto v : e.value) {
                        EnumConstantElement.Builder c = EnumConstantElement.builder().name(v.name).tag(v.number);
                        nestedEnumElement.addConstant(c.build());
                    }
                    messageElementBuilder.addType((TypeElement)nestedEnumElement.build());
                }
            }
            return messageElementBuilder.build();
        }

        static class ReservedRange {
            public int start;
            public int end;

            ReservedRange() {
            }
        }

        static class ExtensionRange {
            public int start;
            public int end;

            ExtensionRange() {
            }
        }
    }

    public static class SourceCodeInfo {
        public Location[] location;

        public static class Location {
            public int[] path;
            public int[] span;
            public String leading_comments;
            public String trailing_comments;
            public String[] leading_detached_comments;
        }
    }

    public static class UninterpretedOption {
        public NamePart[] name;
        public String identifier_value;
        public long positive_int_value;
        public long negative_int_value;
        public double double_value;
        public byte[] string_value;
        public String aggregate_value;

        static class NamePart {
            public String name_part;
            public boolean is_extension;

            NamePart() {
            }
        }
    }

    public static class MethodOptions {
        public boolean deprecated;
        public IdempotencyLevel idempotency_level;
        public UninterpretedOption[] uninterpreted_option;

        static enum IdempotencyLevel {
            IDEMPOTENCY_UNKNOWN,
            NO_SIDE_EFFECTS,
            IDEMPOTENT;

        }
    }

    public static class ServiceOptions {
        public boolean deprecated;
        public UninterpretedOption[] uninterpreted_option;
    }

    public static class EnumValueOptions {
        public boolean deprecated;
        public UninterpretedOption[] uninterpreted_option;
    }

    public static class EnumOptions {
        public boolean allow_alias;
        public boolean deprecated;
        public UninterpretedOption[] uninterpreted_option;
    }

    public static class OneofOptions {
        public UninterpretedOption[] uninterpreted_option;
    }

    public static class FieldOptions {
        public CType ctype;
        public boolean packed;
        public JSType jstype;
        public boolean lazy;
        public boolean deprecated;
        public boolean weak;
        public UninterpretedOption[] uninterpreted_option;

        static enum JSType {
            JS_NORMAL,
            JS_STRING,
            JS_NUMBER;

        }

        static enum CType {
            STRING,
            CORD,
            STRING_PIECE;

        }
    }

    public static class MessageOptions {
        public boolean message_set_wire_format;
        public boolean no_standard_descriptor_accessor;
        public boolean deprecated;
        public boolean map_entry;
        public UninterpretedOption[] uninterpreted_option;
    }

    public static class FileOptions {
        public String java_package;
        public String java_outer_classname;
        public boolean java_multiple_files;
        public boolean java_generate_equals_and_hash;
        public boolean java_String_check_utf8;
        public OptimizeMode optimize_for;
        public String go_package;
        public boolean cc_generic_services;
        public boolean java_generic_services;
        public boolean py_generic_services;
        public boolean deprecated;
        public boolean cc_enable_arenas;
        public String objc_class_prefix;
        public String csharp_namespace;
        public String swift_prefix;
        public String php_class_prefix;
        public UninterpretedOption[] uninterpreted_option;

        static enum OptimizeMode {
            SPEED,
            CODE_SIZE,
            LITE_RUNTIME;

        }
    }

    public static class MethodDescriptorProto {
        public String name;
        public String input_type;
        public String output_type;
        public MethodOptions options;
        public boolean client_streaming;
        public boolean server_streaming;
    }

    public static class ServiceDescriptorProto {
        public String name;
        public MethodDescriptorProto[] method;
        public ServiceOptions options;
    }

    public static class EnumValueDescriptorProto {
        public String name;
        public int number;
        public EnumValueOptions options;
    }

    public static class EnumDescriptorProto {
        public String name;
        public EnumValueDescriptorProto[] value;
        public EnumOptions options;
    }

    public static class OneofDescriptorProto {
        public String name;
        public OneofOptions options;
    }

    public static class FieldDescriptorProto {
        public String name;
        public int number;
        public Label label;
        public Type type;
        public String type_name;
        public String extendee;
        public String default_value;
        public int oneof_index;
        public String json_name;
        public FieldOptions options;
        private static Map<Type, DataType> scalarTypeMap = new EnumMap<Type, DataType>(Type.class);
        private static Map<Label, FieldElement.Label> labelMap = new EnumMap<Label, FieldElement.Label>(Label.class);

        public DataType getDataType() {
            return scalarTypeMap.get((Object)this.type);
        }

        public FieldElement.Label getLabel() {
            return labelMap.get((Object)this.label);
        }

        static {
            scalarTypeMap.put(Type.TYPE_DOUBLE, (DataType)DataType.ScalarType.DOUBLE);
            scalarTypeMap.put(Type.TYPE_FLOAT, (DataType)DataType.ScalarType.FLOAT);
            scalarTypeMap.put(Type.TYPE_INT64, (DataType)DataType.ScalarType.INT64);
            scalarTypeMap.put(Type.TYPE_UINT64, (DataType)DataType.ScalarType.UINT64);
            scalarTypeMap.put(Type.TYPE_INT32, (DataType)DataType.ScalarType.INT32);
            scalarTypeMap.put(Type.TYPE_FIXED64, (DataType)DataType.ScalarType.FIXED64);
            scalarTypeMap.put(Type.TYPE_FIXED32, (DataType)DataType.ScalarType.FIXED32);
            scalarTypeMap.put(Type.TYPE_BOOL, (DataType)DataType.ScalarType.BOOL);
            scalarTypeMap.put(Type.TYPE_STRING, (DataType)DataType.ScalarType.STRING);
            scalarTypeMap.put(Type.TYPE_BYTES, (DataType)DataType.ScalarType.BYTES);
            scalarTypeMap.put(Type.TYPE_UINT32, (DataType)DataType.ScalarType.UINT32);
            scalarTypeMap.put(Type.TYPE_SFIXED32, (DataType)DataType.ScalarType.SFIXED32);
            scalarTypeMap.put(Type.TYPE_SFIXED64, (DataType)DataType.ScalarType.SFIXED64);
            scalarTypeMap.put(Type.TYPE_SINT32, (DataType)DataType.ScalarType.SINT32);
            scalarTypeMap.put(Type.TYPE_SINT64, (DataType)DataType.ScalarType.SINT64);
            labelMap.put(Label.LABEL_OPTIONAL, FieldElement.Label.OPTIONAL);
            labelMap.put(Label.LABEL_REQUIRED, FieldElement.Label.REQUIRED);
            labelMap.put(Label.LABEL_REPEATED, FieldElement.Label.REPEATED);
        }

        public static enum Type {
            TYPE_DOUBLE,
            TYPE_FLOAT,
            TYPE_INT64,
            TYPE_UINT64,
            TYPE_INT32,
            TYPE_FIXED64,
            TYPE_FIXED32,
            TYPE_BOOL,
            TYPE_STRING,
            TYPE_GROUP,
            TYPE_MESSAGE,
            TYPE_BYTES,
            TYPE_UINT32,
            TYPE_ENUM,
            TYPE_SFIXED32,
            TYPE_SFIXED64,
            TYPE_SINT32,
            TYPE_SINT64;

        }

        public static enum Label {
            LABEL_OPTIONAL,
            LABEL_REQUIRED,
            LABEL_REPEATED;

        }
    }
}

