/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.BinaryTSFactory;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.protobuf.PackageVersion;
import tools.jackson.dataformat.protobuf.ProtobufFactoryBuilder;
import tools.jackson.dataformat.protobuf.ProtobufGenerator;
import tools.jackson.dataformat.protobuf.ProtobufParser;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;

public class ProtobufFactory
extends BinaryTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;

    public ProtobufFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), 0, 0);
    }

    protected ProtobufFactory(ProtobufFactory src) {
        super((BinaryTSFactory)src);
    }

    protected ProtobufFactory(ProtobufFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
    }

    public ProtobufFactoryBuilder rebuild() {
        return new ProtobufFactoryBuilder(this);
    }

    public static ProtobufFactoryBuilder builder() {
        return new ProtobufFactoryBuilder();
    }

    public ProtobufFactory copy() {
        return new ProtobufFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new ProtobufFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return "protobuf";
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof ProtobufSchema;
    }

    public int getFormatReadFeatures() {
        return 0;
    }

    public int getFormatWriteFeatures() {
        return 0;
    }

    protected IOContext _createContext(ContentReference contentRef, boolean resourceManaged) {
        return super._createContext(contentRef, resourceManaged);
    }

    protected ProtobufParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        byte[] buf = ioCtxt.allocReadIOBuffer();
        return new ProtobufParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), (ProtobufSchema)readCtxt.getSchema(), in, buf, 0, 0, true);
    }

    protected ProtobufParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return new ProtobufParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), (ProtobufSchema)readCtxt.getSchema(), null, data, offset, len, false);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected ProtobufGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        return new ProtobufGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), (ProtobufSchema)writeCtxt.getSchema(), out);
    }
}

