/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.javaprop.impl;

import java.io.IOException;
import java.io.Writer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.javaprop.JavaPropsGenerator;
import tools.jackson.dataformat.javaprop.JavaPropsSchema;
import tools.jackson.dataformat.javaprop.io.JPropEscapes;

public class WriterBackedGenerator
extends JavaPropsGenerator {
    protected final Writer _out;
    protected char[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;

    public WriterBackedGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int stdFeatures, JavaPropsSchema schema, Writer out) {
        super(writeCtxt, ioCtxt, stdFeatures, schema);
        this._out = out;
        this._outputBuffer = ioCtxt.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    public Object streamWriteOutputTarget() {
        return this._out;
    }

    public int streamWriteOutputBuffered() {
        return this._outputTail;
    }

    public void close() {
        if (!this.isClosed()) {
            this._flushBuffer();
            this._outputTail = 0;
            super.close();
        }
    }

    protected void _closeInput() throws IOException {
        if (this._out != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._out.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._out.flush();
            }
        }
    }

    public void flush() {
        this._flushBuffer();
        if (this._out != null && this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._out.flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    protected void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    protected void _flushBuffer() throws JacksonException {
        if (this._outputTail > 0) {
            try {
                this._out.write(this._outputBuffer, 0, this._outputTail);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            this._outputTail = 0;
        }
    }

    @Override
    protected void _appendPropertyName(StringBuilder path, String name) {
        JPropEscapes.appendKey(this._basePath, name);
    }

    @Override
    protected void _writeEscapedEntry(String value) throws JacksonException {
        this._writeRaw(this._basePath);
        this._writeRaw(this._schema.keyValueSeparator());
        this._writeEscaped(value);
        this._writeLinefeed();
    }

    @Override
    protected void _writeEscapedEntry(char[] text, int offset, int len) throws JacksonException {
        this._writeRaw(this._basePath);
        this._writeRaw(this._schema.keyValueSeparator());
        this._writeEscaped(text, offset, len);
        this._writeLinefeed();
    }

    @Override
    protected void _writeUnescapedEntry(String value) throws JacksonException {
        this._writeRaw(this._basePath);
        this._writeRaw(this._schema.keyValueSeparator());
        this._writeRaw(value);
        this._writeLinefeed();
    }

    protected void _writeEscaped(String value) throws JacksonException {
        StringBuilder sb = JPropEscapes.appendValue(value);
        if (sb == null) {
            this._writeRaw(value);
        } else {
            this._writeRaw(sb);
        }
    }

    protected void _writeEscaped(char[] text, int offset, int len) throws JacksonException {
        this._writeEscaped(new String(text, offset, len));
    }

    protected void _writeLinefeed() throws JacksonException {
        this._writeRaw(this._schema.lineEnding());
    }

    @Override
    protected void _writeRaw(char c) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    @Override
    protected void _writeRaw(String text) throws JacksonException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
    }

    @Override
    protected void _writeRaw(StringBuilder text) throws JacksonException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
    }

    @Override
    protected void _writeRaw(char[] text, int offset, int len) throws JacksonException {
        if (len < 100) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return;
        }
        this._flushBuffer();
        try {
            this._out.write(text, offset, len);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected void _writeRawLong(String text) throws JacksonException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    protected void _writeRawLong(StringBuilder text) throws JacksonException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }
}

