/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.ion.IonFactory;
import tools.jackson.dataformat.ion.IonReadFeature;
import tools.jackson.dataformat.ion.IonWriteFeature;

public class IonFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<IonFactory, IonFactoryBuilder> {
    protected IonSystem _system;
    protected boolean _createBinaryWriters;

    protected IonFactoryBuilder(boolean createBinary) {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), IonFactory.DEFAULT_ION_PARSER_FEATURE_FLAGS, IonFactory.DEFAULT_ION_GENERATOR_FEATURE_FLAGS);
        this._createBinaryWriters = createBinary;
    }

    public IonFactoryBuilder(IonFactory base) {
        super((DecorableTSFactory)base);
        this._createBinaryWriters = base._cfgBinaryWriters;
    }

    public IonFactory build() {
        return new IonFactory(this);
    }

    public IonFactoryBuilder withBinaryWriters() {
        this._createBinaryWriters = true;
        return this;
    }

    public IonFactoryBuilder withTextualWriters() {
        this._createBinaryWriters = false;
        return this;
    }

    public IonFactoryBuilder ionSystem(IonSystem system) {
        this._system = system;
        return this;
    }

    public IonFactoryBuilder enable(IonReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder enable(IonReadFeature first, IonReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (IonReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonReadFeature first, IonReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (IonReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder configure(IonReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public IonFactoryBuilder enable(IonWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder enable(IonWriteFeature first, IonWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (IonWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonWriteFeature first, IonWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (IonWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder configure(IonWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public boolean willCreateBinaryWriters() {
        return this._createBinaryWriters;
    }

    public IonSystem ionSystem() {
        if (this._system == null) {
            return IonSystemBuilder.standard().build();
        }
        return this._system;
    }
}

