/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import tools.jackson.core.FormatFeature;

public enum IonReadFeature implements FormatFeature
{
    READ_NULL_AS_IONVALUE(true),
    USE_NATIVE_TYPE_ID(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (IonReadFeature f : IonReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private IonReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    public int getMask() {
        return this._mask;
    }
}

