/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.jsr310;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneOffset;

final class TimestampUtils {
    private static final BigDecimal ONE_THOUSAND = new BigDecimal("1000");
    private static final BigDecimal ONE_MILLION = new BigDecimal("1000000");
    private static final BigDecimal ONE_BILLION = new BigDecimal("1000000000");

    private TimestampUtils() {
    }

    static Timestamp toTimestamp(Instant instant, ZoneOffset offset) {
        Integer offsetMinutes = offset == null ? null : Integer.valueOf(TimestampUtils.secondsToMinutes(offset.getTotalSeconds()));
        return Timestamp.forMillis((BigDecimal)TimestampUtils.getFractionalMillis(instant), (Integer)offsetMinutes);
    }

    static Instant toInstant(Timestamp timestamp) {
        BigDecimal decSeconds = timestamp.getDecimalMillis().divide(ONE_THOUSAND);
        long epocSeconds = decSeconds.longValue();
        long nanoAdjustment = decSeconds.subtract(BigDecimal.valueOf(epocSeconds)).multiply(ONE_BILLION).longValue();
        return Instant.ofEpochSecond(epocSeconds, nanoAdjustment);
    }

    static BigDecimal getFractionalSeconds(Instant instant) {
        BigDecimal epochSeconds = BigDecimal.valueOf(instant.getEpochSecond());
        BigDecimal nanos = BigDecimal.valueOf(instant.getNano());
        return epochSeconds.add(nanos.divide(ONE_BILLION));
    }

    static BigDecimal getFractionalMillis(Instant instant) {
        BigDecimal epochSeconds = BigDecimal.valueOf(instant.getEpochSecond());
        BigDecimal nanos = BigDecimal.valueOf(instant.getNano());
        return epochSeconds.multiply(ONE_THOUSAND).add(nanos.divide(ONE_MILLION));
    }

    static Instant fromFractionalSeconds(BigDecimal seconds) {
        long secondsOnly;
        int nanosOnly;
        BigDecimal nanoseconds = seconds.scaleByPowerOfTen(9);
        if (nanoseconds.precision() - nanoseconds.scale() <= 0) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else if (seconds.scale() < -63) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else {
            secondsOnly = seconds.longValue();
            nanosOnly = nanoseconds.subtract(new BigDecimal(secondsOnly).scaleByPowerOfTen(9)).intValue();
            if (secondsOnly < 0L && secondsOnly > Instant.MIN.getEpochSecond()) {
                nanosOnly = Math.abs(nanosOnly);
            }
        }
        return Instant.ofEpochSecond(secondsOnly, nanosOnly);
    }

    private static int secondsToMinutes(int seconds) {
        return Math.floorDiv(seconds, 60);
    }
}

