/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.IonContainer;
import com.amazon.ion.IonDatagram;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.dataformat.ion.EnumAsIonSymbolModule;
import tools.jackson.dataformat.ion.IonFactory;
import tools.jackson.dataformat.ion.IonGenerator;
import tools.jackson.dataformat.ion.IonParser;
import tools.jackson.dataformat.ion.IonReadFeature;
import tools.jackson.dataformat.ion.IonTimestampDeserializers;
import tools.jackson.dataformat.ion.IonTimestampSerializers;
import tools.jackson.dataformat.ion.IonWriteFeature;
import tools.jackson.dataformat.ion.PackageVersion;
import tools.jackson.dataformat.ion.ionvalue.IonValueModule;

public class IonObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public IonObjectMapper() {
        this(new IonFactory());
    }

    public IonObjectMapper(IonFactory f) {
        this(new Builder(f));
    }

    public IonObjectMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return IonObjectMapper.builderForTextualWriters();
    }

    public static Builder builder(IonFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public static Builder builder(IonSystem ionSystem) {
        return IonObjectMapper.builderForTextualWriters(ionSystem);
    }

    public static Builder builderForBinaryWriters() {
        return IonObjectMapper.builderForBinaryWriters(IonSystemBuilder.standard().build());
    }

    public static Builder builderForBinaryWriters(IonSystem ionSystem) {
        return IonObjectMapper.builder(IonFactory.builderForBinaryWriters().ionSystem(ionSystem).build());
    }

    public static Builder builderForTextualWriters() {
        return IonObjectMapper.builderForTextualWriters(IonSystemBuilder.standard().build());
    }

    public static Builder builderForTextualWriters(IonSystem ionSystem) {
        return IonObjectMapper.builder(IonFactory.builderForTextualWriters().ionSystem(ionSystem).build());
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static IonObjectMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public IonFactory tokenStreamFactory() {
        return (IonFactory)this._streamFactory;
    }

    public IonParser createParser(IonReader src) {
        DeserializationContextExt ctxt = this._deserializationContext();
        return (IonParser)ctxt.assignAndReturnParser((JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, src));
    }

    public IonParser createParser(IonValue value) {
        DeserializationContextExt ctxt = this._deserializationContext();
        return (IonParser)ctxt.assignAndReturnParser((JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, value));
    }

    public IonGenerator createGenerator(IonWriter out) {
        return this.tokenStreamFactory().createGenerator((ObjectWriteContext)this._serializationContext(), out);
    }

    public <T> T readValue(IonReader r, Class<T> valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, r), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonReader r, TypeReference valueTypeRef) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, r), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonReader r, JavaType valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, r), valueType);
    }

    public <T> T readValue(IonValue value, Class<T> valueType) throws IOException {
        if (value == null) {
            return null;
        }
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, value), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonValue value, TypeReference valueTypeRef) throws IOException {
        if (value == null) {
            return null;
        }
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, value), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonValue value, JavaType valueType) throws IOException {
        if (value == null) {
            return null;
        }
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, (JsonParser)this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, value), valueType);
    }

    public void writeValue(IonWriter w, Object value) throws IOException {
        SerializationContextExt prov = this._serializationContext();
        this._configAndWriteValue(prov, (JsonGenerator)this.tokenStreamFactory().createGenerator((ObjectWriteContext)prov, w), value);
    }

    public IonValue writeValueAsIonValue(Object value) throws IOException {
        IonFactory f = this.tokenStreamFactory();
        IonDatagram container = f._system.newDatagram();
        try (IonWriter writer = f._system.newWriter((IonContainer)container);){
            this.writeValue(writer, value);
            IonValue result = container.get(0);
            result.removeFromContainer();
            IonValue ionValue = result;
            return ionValue;
        }
    }

    public static class Builder
    extends MapperBuilder<IonObjectMapper, Builder> {
        public Builder(IonFactory f) {
            super((TokenStreamFactory)f);
            this.addModule(new IonValueModule());
            this.addModule(new EnumAsIonSymbolModule());
            SimpleModule m = new SimpleModule("IonTimestampModule", PackageVersion.VERSION, (Object)"IonTimestampModule");
            m.addSerializer(java.util.Date.class, (ValueSerializer)new IonTimestampSerializers.IonTimestampJavaDateSerializer());
            m.addSerializer(Date.class, (ValueSerializer)new IonTimestampSerializers.IonTimestampSQLDateSerializer());
            m.addDeserializer(java.util.Date.class, (ValueDeserializer)new IonTimestampDeserializers.IonTimestampJavaDateDeserializer());
            m.addDeserializer(Date.class, (ValueDeserializer)new IonTimestampDeserializers.IonTimestampSQLDateDeserializer());
            this.addModule((JacksonModule)m);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public IonObjectMapper build() {
            return new IonObjectMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(IonReadFeature ... features) {
            for (IonReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(IonReadFeature ... features) {
            for (IonReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(IonReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(IonWriteFeature ... features) {
            for (IonWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(IonWriteFeature ... features) {
            for (IonWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(IonWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final IonObjectMapper MAPPER = IonObjectMapper.builder().build();

        private SharedWrapper() {
        }

        public static IonObjectMapper wrapped() {
            return MAPPER;
        }
    }
}

