/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonContainer;
import com.amazon.ion.IonException;
import com.amazon.ion.IonList;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import com.amazon.ion.UnknownSymbolException;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamReadContext;
import tools.jackson.dataformat.ion.IonReadFeature;
import tools.jackson.dataformat.ion.PackageVersion;

public class IonParser
extends ParserMinimalBase {
    protected static final JacksonFeatureSet<StreamReadCapability> ION_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.EXACT_FLOATS);
    protected final IonReader _reader;
    private final IonSystem _system;
    protected int _formatFeatures;
    protected SimpleStreamReadContext _streamReadContext;
    protected JsonToken _valueToken;

    public IonParser(ObjectReadContext readCtxt, IOContext ioCtxt, int streamReadFeatures, int formatFeatures, IonReader r, IonSystem system) {
        super(readCtxt, ioCtxt, streamReadFeatures);
        this._reader = r;
        this._formatFeatures = formatFeatures;
        this._streamReadContext = SimpleStreamReadContext.createRootContext((int)-1, (int)-1, null);
        this._system = system;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public IonSystem getIonSystem() {
        return this._system;
    }

    public IOContext ioContext() {
        return this._ioContext;
    }

    public boolean canReadTypeId() {
        return IonReadFeature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    public boolean hasStringCharacters() {
        return false;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return ION_READ_CAPABILITIES;
    }

    protected void _closeInput() throws IOException {
        Object src;
        if (this._ioContext.isResourceManaged() && (src = this._ioContext.contentReference().getRawContent()) instanceof Closeable) {
            try {
                ((Closeable)src).close();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    protected void _releaseBuffers() {
    }

    public IonReader streamReadInputSource() {
        return this._reader;
    }

    public String getString() throws JacksonException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case PROPERTY_NAME: {
                    return this.currentName();
                }
                case VALUE_STRING: {
                    try {
                        return this._reader.stringValue();
                    }
                    catch (IonException e) {
                        return (String)this._reportCorruptContent(e);
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Number n = this.getNumberValue();
                    return n == null ? null : n.toString();
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Timestamp ts;
                    if (this._reader.getType() != IonType.TIMESTAMP || (ts = this._timestampFromIonReader()) == null) break;
                    return ts.toString();
                }
            }
            return this._currToken.asString();
        }
        return null;
    }

    public char[] getStringCharacters() throws JacksonException {
        String str = this.getString();
        return str == null ? null : str.toCharArray();
    }

    public int getStringLength() throws JacksonException {
        String str = this.getString();
        return str == null ? 0 : str.length();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public BigInteger getBigIntegerValue() throws JacksonException {
        this._verifyIsNumberToken();
        return this._getBigIntegerValue();
    }

    private BigInteger _getBigIntegerValue() throws JacksonException {
        try {
            return this._reader.bigIntegerValue();
        }
        catch (IonException e) {
            return (BigInteger)this._reportCorruptNumber(e);
        }
    }

    public BigDecimal getDecimalValue() throws JacksonException {
        this._verifyIsNumberToken();
        return this._getBigDecimalValue();
    }

    private BigDecimal _getBigDecimalValue() throws JacksonException {
        try {
            return this._reader.bigDecimalValue();
        }
        catch (IonException e) {
            return (BigDecimal)this._reportCorruptNumber(e);
        }
    }

    public double getDoubleValue() throws JacksonException {
        this._verifyIsNumberToken();
        return this._getDoubleValue();
    }

    private double _getDoubleValue() throws JacksonException {
        try {
            return this._reader.doubleValue();
        }
        catch (IonException e) {
            return (Double)this._reportCorruptNumber(e);
        }
    }

    public float getFloatValue() throws JacksonException {
        this._verifyIsNumberToken();
        return (float)this._getDoubleValue();
    }

    public int getIntValue() throws JacksonException {
        this._verifyIsNumberToken();
        return this._getIntValue();
    }

    private int _getIntValue() throws JacksonException {
        try {
            JsonParser.NumberType numberType = this.getNumberType();
            if (numberType == JsonParser.NumberType.LONG) {
                int result = this._reader.intValue();
                if ((long)result != this._reader.longValue()) {
                    this._reportOverflowInt();
                }
                return result;
            }
            if (numberType == JsonParser.NumberType.BIG_INTEGER) {
                BigInteger bigInteger = this._reader.bigIntegerValue();
                if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                    this._reportOverflowInt();
                }
                return bigInteger.intValue();
            }
            return this._reader.intValue();
        }
        catch (IonException e) {
            return (Integer)this._reportCorruptNumber(e);
        }
    }

    public long getLongValue() throws JacksonException {
        this._verifyIsNumberToken();
        return this._getLongValue();
    }

    private long _getLongValue() throws JacksonException {
        try {
            if (this.getNumberType() == JsonParser.NumberType.BIG_INTEGER) {
                BigInteger bigInteger = this._reader.bigIntegerValue();
                if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                    this._reportOverflowLong();
                }
                return bigInteger.longValue();
            }
            return this._reader.longValue();
        }
        catch (IonException e) {
            return (Long)this._reportCorruptNumber(e);
        }
    }

    private void _verifyIsNumberToken() throws JacksonException {
        if (this._currToken != JsonToken.VALUE_NUMBER_INT && this._currToken != JsonToken.VALUE_NUMBER_FLOAT) {
            throw this._constructReadException("Current token (%s) not numeric, can not use numeric value accessors", this._currToken);
        }
    }

    public JsonParser.NumberType getNumberType() throws JacksonException {
        IonType type;
        if ((this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT || this._currToken == null && !this.isClosed()) && (type = this._reader.getType()) != null) {
            switch (type) {
                case DECIMAL: {
                    return JsonParser.NumberType.BIG_DECIMAL;
                }
                case INT: {
                    IntegerSize size;
                    try {
                        size = this._reader.getIntegerSize();
                    }
                    catch (IonException e) {
                        return (JsonParser.NumberType)this._reportCorruptNumber(e);
                    }
                    if (size == null) {
                        this._reportError("Current token (%s) not integer", this._currToken);
                    }
                    switch (size) {
                        case INT: {
                            return JsonParser.NumberType.INT;
                        }
                        case LONG: {
                            return JsonParser.NumberType.LONG;
                        }
                    }
                    return JsonParser.NumberType.BIG_INTEGER;
                }
                case FLOAT: {
                    return JsonParser.NumberType.DOUBLE;
                }
            }
        }
        return null;
    }

    public JsonParser.NumberTypeFP getNumberTypeFP() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            IonType type = this._reader.getType();
            if (type == IonType.FLOAT) {
                return JsonParser.NumberTypeFP.DOUBLE64;
            }
            if (type == IonType.DECIMAL) {
                return JsonParser.NumberTypeFP.BIG_DECIMAL;
            }
        }
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    public Number getNumberValue() throws JacksonException {
        JsonParser.NumberType nt = this.getNumberType();
        if (nt != null) {
            switch (nt) {
                case INT: {
                    return this._getIntValue();
                }
                case LONG: {
                    return this._getLongValue();
                }
                case FLOAT: {
                    return Float.valueOf((float)this._getDoubleValue());
                }
                case DOUBLE: {
                    return this._getDoubleValue();
                }
                case BIG_DECIMAL: {
                    return this._getBigDecimalValue();
                }
                case BIG_INTEGER: {
                    return this._getBigIntegerValue();
                }
            }
        }
        return null;
    }

    public final Number getNumberValueExact() throws JacksonException {
        return this.getNumberValue();
    }

    public boolean isNaN() throws JacksonException {
        return false;
    }

    public byte[] getBinaryValue(Base64Variant arg0) throws JacksonException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case BLOB: 
                case CLOB: {
                    return this._bytesFromIonReader();
                }
            }
        }
        return null;
    }

    private IonValue getIonValue() throws JacksonException {
        if (this._system == null) {
            throw new IllegalStateException("This " + ((Object)((Object)this)).getClass().getSimpleName() + " instance cannot be used for IonValue mapping");
        }
        this._updateToken(JsonToken.VALUE_EMBEDDED_OBJECT);
        IonList l = this._system.newEmptyList();
        IonWriter writer = this._system.newWriter((IonContainer)l);
        try {
            writer.writeValue(this._reader);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        IonValue v = l.get(0);
        v.removeFromContainer();
        return v;
    }

    public Object getEmbeddedObject() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case TIMESTAMP: {
                    return this._timestampFromIonReader();
                }
                case BLOB: 
                case CLOB: {
                    return this._bytesFromIonReader();
                }
            }
        }
        return this.getIonValue();
    }

    private byte[] _bytesFromIonReader() throws JacksonException {
        return this._reader.newBytes();
    }

    private Timestamp _timestampFromIonReader() throws JacksonException {
        try {
            return this._reader.timestampValue();
        }
        catch (IllegalArgumentException e) {
            throw this._constructReadException(String.format("Invalid embedded TIMESTAMP value, problem: %s", e.getMessage()), e);
        }
    }

    public Object getTypeId() throws JacksonException {
        String[] typeAnnotations = this.getTypeAnnotations();
        return typeAnnotations.length == 0 ? null : typeAnnotations[0];
    }

    public TokenStreamLocation currentLocation() {
        return TokenStreamLocation.NA;
    }

    public String currentName() throws JacksonException {
        return this._streamReadContext.currentName();
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public TokenStreamLocation currentTokenLocation() {
        return TokenStreamLocation.NA;
    }

    public JsonToken nextToken() throws JacksonException {
        String name;
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._updateToken(this._valueToken);
        }
        if (this._currToken == JsonToken.START_OBJECT) {
            this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
            this._reader.stepIn();
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._streamReadContext = this._streamReadContext.createChildArrayContext(-1, -1);
            this._reader.stepIn();
        }
        IonType type = null;
        try {
            type = this._reader.next();
        }
        catch (IonException e) {
            return (JsonToken)this._reportCorruptContent(e);
        }
        if (type == null) {
            if (this._streamReadContext.inRoot()) {
                this._updateTokenToNull();
            } else {
                this._streamReadContext = this._streamReadContext.getParent();
                this._updateToken(this._reader.isInStruct() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY);
                this._reader.stepOut();
            }
            return this._currToken;
        }
        boolean inStruct = !this._streamReadContext.inRoot() && this._reader.isInStruct();
        try {
            name = inStruct ? this._reader.getFieldName() : null;
        }
        catch (IonException e) {
            return (JsonToken)this._reportCorruptContent(e);
        }
        this._streamReadContext.setCurrentName(name);
        JsonToken t = this._tokenFromType(type);
        if (inStruct) {
            this._valueToken = t;
            return this._updateToken(JsonToken.PROPERTY_NAME);
        }
        return this._updateToken(t);
    }

    public String[] getTypeAnnotations() throws JacksonException {
        try {
            return this._reader.getTypeAnnotations();
        }
        catch (UnknownSymbolException e) {
            throw this._constructReadException(e.getMessage(), e);
        }
    }

    public JsonParser skipChildren() throws JacksonException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return this;
                }
            }
        }
    }

    protected JsonToken _tokenFromType(IonType type) {
        if (this._reader.isNullValue()) {
            return JsonToken.VALUE_NULL;
        }
        switch (type) {
            case BOOL: {
                return this._reader.booleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case DECIMAL: 
            case FLOAT: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case INT: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case STRING: 
            case SYMBOL: {
                return JsonToken.VALUE_STRING;
            }
            case NULL: {
                return JsonToken.VALUE_NULL;
            }
            case LIST: 
            case SEXP: {
                return JsonToken.START_ARRAY;
            }
            case STRUCT: {
                return JsonToken.START_OBJECT;
            }
            case TIMESTAMP: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected void _handleEOF() throws StreamReadException {
        if (!this._streamReadContext.inRoot()) {
            this._reportError(": expected close marker for " + this._streamReadContext.typeDesc() + " (from " + String.valueOf(this._streamReadContext.startLocation(this._ioContext.contentReference())) + ")");
        }
    }

    private <T> T _reportCorruptContent(Throwable e) throws StreamReadException {
        String origMsg = e.getMessage();
        if (origMsg == null) {
            origMsg = "[no exception message]";
        }
        String msg = String.format("Corrupt content to decode; underlying `IonReader` problem: (%s) %s", e.getClass().getName(), origMsg);
        throw this._constructReadException(msg, e);
    }

    private <T> T _reportCorruptNumber(Throwable e) throws StreamReadException {
        String origMsg = e.getMessage();
        if (origMsg == null) {
            origMsg = "[no exception message]";
        }
        String msg = String.format("Corrupt Number value to decode; underlying `IonReader` problem: (%s) %s", e.getClass().getName(), origMsg);
        throw this._constructReadException(msg, e);
    }
}

