/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.io.File;
import java.io.Serializable;
import org.apache.avro.Schema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.ser.std.ToStringSerializer;
import tools.jackson.dataformat.avro.AvroAnnotationIntrospector;
import tools.jackson.dataformat.avro.AvroSerializerModifier;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.deser.AvroUntypedDeserializer;

public class AvroModule
extends JacksonModule
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected static final AvroAnnotationIntrospector INTR = new AvroAnnotationIntrospector();
    protected AnnotationIntrospector _intr = INTR;

    public String getModuleName() {
        return this.getClass().getName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroModule withAnnotationIntrospector(AnnotationIntrospector intr) {
        this._intr = intr;
        return this;
    }

    public void setupModule(JacksonModule.SetupContext context) {
        this._addIntrospector(context);
        this._addModifiers(context);
        this._addDeserializers(context);
        this._addSerializers(context);
    }

    protected void _addIntrospector(JacksonModule.SetupContext context) {
        if (this._intr != null) {
            context.insertAnnotationIntrospector(this._intr);
        }
    }

    protected void _addModifiers(JacksonModule.SetupContext context) {
        context.addSerializerModifier((ValueSerializerModifier)new AvroSerializerModifier());
    }

    protected void _addDeserializers(JacksonModule.SetupContext context) {
        SimpleDeserializers desers = new SimpleDeserializers();
        desers.addDeserializer(Object.class, (ValueDeserializer)AvroUntypedDeserializer.construct(context.typeFactory()));
        context.addDeserializers((Deserializers)desers);
    }

    protected void _addSerializers(JacksonModule.SetupContext context) {
        SimpleSerializers sers = new SimpleSerializers();
        sers.addSerializer((ValueSerializer)new SchemaSerializer());
        sers.addSerializer(File.class, (ValueSerializer)new ToStringSerializer(File.class));
        context.addSerializers((Serializers)sers);
    }

    public static class SchemaSerializer
    extends StdSerializer<Schema> {
        public SchemaSerializer() {
            super(Schema.class);
        }

        public void serialize(Schema value, JsonGenerator gen, SerializationContext prov) throws JacksonException {
            gen.writeString(value.toString());
        }
    }
}

