/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.avro.AvroFactory;
import tools.jackson.dataformat.avro.AvroReadFeature;
import tools.jackson.dataformat.avro.AvroWriteFeature;

public class AvroFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<AvroFactory, AvroFactoryBuilder> {
    protected boolean _useApacheLibDecoder;

    protected AvroFactoryBuilder() {
        this(false);
    }

    protected AvroFactoryBuilder(boolean useApacheDecoder) {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), AvroFactory.DEFAULT_AVRO_PARSER_FEATURE_FLAGS, AvroFactory.DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS);
        this._useApacheLibDecoder = useApacheDecoder;
        this._streamWriteFeatures &= ~StreamWriteFeature.AUTO_CLOSE_CONTENT.getMask();
    }

    public AvroFactoryBuilder(AvroFactory base) {
        super((DecorableTSFactory)base);
    }

    public AvroFactory build() {
        return new AvroFactory(this);
    }

    public boolean useApacheLibDecoder() {
        return this._useApacheLibDecoder;
    }

    public AvroFactoryBuilder enable(AvroReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder enable(AvroReadFeature first, AvroReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (AvroReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroReadFeature first, AvroReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (AvroReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder configure(AvroReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public AvroFactoryBuilder enable(AvroWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder enable(AvroWriteFeature first, AvroWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (AvroWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroWriteFeature first, AvroWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (AvroWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder configure(AvroWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }
}

