/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.apacheimpl;

import java.io.IOException;
import org.apache.avro.reflect.CustomEncoding;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.dataformat.avro.CustomEncodingWrapper;
import tools.jackson.dataformat.avro.apacheimpl.DecoderOverAvroParser;
import tools.jackson.dataformat.avro.deser.AvroParserImpl;

public class CustomEncodingDeserializer<T>
extends ValueDeserializer<T> {
    private final CustomEncodingWrapper<T> encoding;

    public CustomEncodingDeserializer(CustomEncoding<T> encoding) {
        this.encoding = new CustomEncodingWrapper<T>(encoding);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        AvroParserImpl avroParser = (AvroParserImpl)p;
        DecoderOverAvroParser decoder = new DecoderOverAvroParser(avroParser);
        try {
            return this.encoding.read(null, decoder);
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws JacksonException {
        AvroParserImpl avroParser = (AvroParserImpl)p;
        DecoderOverAvroParser decoder = new DecoderOverAvroParser(avroParser);
        try {
            return this.encoding.read(intoValue, decoder);
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }
}

