/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.BinaryTSFactory;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.RecyclerPool;
import tools.jackson.dataformat.avro.AvroFactoryBuilder;
import tools.jackson.dataformat.avro.AvroGenerator;
import tools.jackson.dataformat.avro.AvroParser;
import tools.jackson.dataformat.avro.AvroReadFeature;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.AvroWriteFeature;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.apacheimpl.ApacheAvroParserImpl;
import tools.jackson.dataformat.avro.apacheimpl.ApacheCodecRecycler;
import tools.jackson.dataformat.avro.apacheimpl.AvroRecyclerPools;
import tools.jackson.dataformat.avro.deser.JacksonAvroParserImpl;

public class AvroFactory
extends BinaryTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_AVRO = "avro";
    static final int DEFAULT_AVRO_PARSER_FEATURE_FLAGS = AvroReadFeature.collectDefaults();
    static final int DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS = AvroWriteFeature.collectDefaults();
    protected RecyclerPool<ApacheCodecRecycler> _avroRecyclerPool = AvroRecyclerPools.defaultPool();
    protected boolean _useApacheLibDecoder;

    public AvroFactory() {
        super((DecorableTSFactory.DecorableTSFBuilder)new AvroFactoryBuilder());
    }

    protected AvroFactory(AvroFactory src) {
        super((BinaryTSFactory)src);
        this._useApacheLibDecoder = src._useApacheLibDecoder;
    }

    protected AvroFactory(AvroFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
        this._useApacheLibDecoder = b.useApacheLibDecoder();
    }

    public AvroFactoryBuilder rebuild() {
        return new AvroFactoryBuilder(this);
    }

    public static AvroFactoryBuilder builder() {
        return new AvroFactoryBuilder();
    }

    public static AvroFactoryBuilder builderWithApacheDecoder() {
        return new AvroFactoryBuilder(true);
    }

    public static AvroFactoryBuilder builderWithNativeDecoder() {
        return new AvroFactoryBuilder(false);
    }

    public AvroFactory copy() {
        return new AvroFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    public boolean canHandleBinaryNatively() {
        return true;
    }

    protected Object readResolve() {
        return new AvroFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public boolean canParseAsync() {
        return false;
    }

    public final boolean isEnabled(AvroReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(AvroWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    public String getFormatName() {
        return FORMAT_NAME_AVRO;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof AvroSchema;
    }

    public Class<AvroReadFeature> getFormatReadFeatureType() {
        return AvroReadFeature.class;
    }

    public Class<AvroWriteFeature> getFormatWriteFeatureType() {
        return AvroWriteFeature.class;
    }

    protected AvroParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) throws JacksonException {
        if (this._useApacheLibDecoder) {
            return new ApacheAvroParserImpl(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), (ApacheCodecRecycler)this._avroRecyclerPool.acquireAndLinkPooled(), (AvroSchema)readCtxt.getSchema(), in);
        }
        return new JacksonAvroParserImpl(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), (AvroSchema)readCtxt.getSchema(), in);
    }

    protected AvroParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) throws JacksonException {
        if (this._useApacheLibDecoder) {
            return new ApacheAvroParserImpl(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), (ApacheCodecRecycler)this._avroRecyclerPool.acquireAndLinkPooled(), (AvroSchema)readCtxt.getSchema(), data, offset, len);
        }
        return new JacksonAvroParserImpl(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), (AvroSchema)readCtxt.getSchema(), data, offset, len);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) throws JacksonException {
        return new AvroGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), (ApacheCodecRecycler)this._avroRecyclerPool.acquireAndLinkPooled(), (AvroSchema)writeCtxt.getSchema(), out);
    }
}

