/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.ser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import tools.jackson.dataformat.avro.ser.AvroWriteContext;
import tools.jackson.dataformat.avro.ser.EncodedDatum;

public class NonBSGenericDatumWriter<D>
extends GenericDatumWriter<D> {
    private static final GenericData GENERIC_DATA = GenericData.get();
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_BIG_DECIMAL = BigDecimal.class;
    private static final Class<?> CLS_BIG_INTEGER = BigInteger.class;
    private static final Conversions.DecimalConversion BIG_DECIMAL_CONVERSION = new Conversions.DecimalConversion();

    public NonBSGenericDatumWriter(Schema root) {
        super(root);
    }

    public int resolveUnion(Schema union, Object datum) {
        return AvroWriteContext.resolveUnionIndex(union, datum);
    }

    protected void write(Schema schema, Object datum, Encoder out) throws IOException {
        if (datum == null) {
            super.writeWithoutConversion(schema, datum, out);
            return;
        }
        switch (schema.getType()) {
            case STRING: {
                Class<?> raw = datum.getClass();
                if (raw == CLS_STRING) {
                    this.writeString(datum, out);
                    return;
                }
                if (raw != CLS_BIG_DECIMAL && raw != CLS_BIG_INTEGER) break;
                this.writeString(datum.toString(), out);
                return;
            }
            case ENUM: {
                super.writeWithoutConversion(schema, GENERIC_DATA.createEnum(datum.toString(), schema), out);
                return;
            }
            case INT: {
                String str;
                int len;
                if (datum.getClass() != CLS_STRING || (len = (str = (String)datum).length()) != 1) break;
                super.writeWithoutConversion(schema, (Object)str.charAt(0), out);
                return;
            }
            case LONG: {
                if (datum.getClass() != CLS_BIG_INTEGER) break;
                datum = ((BigInteger)datum).longValue();
                break;
            }
            case DOUBLE: {
                if (datum.getClass() != CLS_BIG_DECIMAL) break;
                datum = ((BigDecimal)datum).doubleValue();
                break;
            }
            case ARRAY: {
                if (datum.getClass() != CLS_STRING || schema.getElementType().getType() != Schema.Type.INT) break;
                String str = (String)datum;
                int len = str.length();
                ArrayList<Integer> chars = new ArrayList<Integer>(len);
                for (int i = 0; i < len; ++i) {
                    chars.add(Integer.valueOf(str.charAt(i)));
                }
                super.writeWithoutConversion(schema, chars, out);
                return;
            }
            case BYTES: {
                if (datum instanceof byte[]) {
                    super.writeWithoutConversion(schema, (Object)ByteBuffer.wrap((byte[])datum), out);
                    return;
                }
                if (datum.getClass() != CLS_BIG_DECIMAL) break;
                super.writeWithoutConversion(schema, (Object)BIG_DECIMAL_CONVERSION.toBytes((BigDecimal)datum, schema, schema.getLogicalType()), out);
                return;
            }
            case FIXED: {
                if (datum instanceof byte[]) {
                    super.writeWithoutConversion(schema, (Object)new GenericData.Fixed(schema, (byte[])datum), out);
                    return;
                }
                if (datum.getClass() != CLS_BIG_DECIMAL) break;
                super.writeWithoutConversion(schema, (Object)BIG_DECIMAL_CONVERSION.toFixed((BigDecimal)datum, schema, schema.getLogicalType()), out);
                return;
            }
        }
        if (datum instanceof EncodedDatum) {
            ((EncodedDatum)datum).write(out);
            return;
        }
        super.writeWithoutConversion(schema, datum, out);
    }
}

