/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.TypeDeserializerBase;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;

public class AvroTypeDeserializer
extends TypeDeserializerBase {
    protected AvroTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(baseType, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    protected AvroTypeDeserializer(TypeDeserializerBase src, BeanProperty property) {
        super(src, property);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return new AvroTypeDeserializer(this, prop);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXISTING_PROPERTY;
    }

    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.getTypeId() == null && this.getDefaultImpl() == null) {
            ValueDeserializer deser = this._findDeserializer(ctxt, AvroSchemaHelper.getTypeId(this._baseType));
            if (deser == null) {
                ctxt.reportInputMismatch(this._baseType, "No (native) type id found when one was expected for polymorphic type handling", new Object[0]);
                return null;
            }
            return deser.deserialize(p, ctxt);
        }
        return this._deserializeWithNativeTypeId(p, ctxt, p.getTypeId());
    }

    protected JavaType _handleUnknownTypeId(DeserializationContext ctxt, String typeId) throws JacksonException {
        return super._handleUnknownTypeId(ctxt, typeId);
    }
}

