/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.json.JsonReadContext;

public class TokenBufferReadContext
extends TokenStreamContext {
    protected final TokenStreamContext _parent;
    protected final TokenStreamLocation _startLocation;
    protected String _currentName;
    protected Object _currentValue;

    protected TokenBufferReadContext(TokenStreamContext base, ContentReference contentRef) {
        super(base);
        this._parent = base.getParent();
        this._currentName = base.currentName();
        this._currentValue = base.currentValue();
        if (base instanceof JsonReadContext) {
            JsonReadContext rc = (JsonReadContext)base;
            this._startLocation = rc.startLocation(contentRef);
        } else {
            this._startLocation = TokenStreamLocation.NA;
        }
    }

    protected TokenBufferReadContext(TokenStreamContext base, TokenStreamLocation startLoc) {
        super(base);
        this._parent = base.getParent();
        this._currentName = base.currentName();
        this._currentValue = base.currentValue();
        this._startLocation = startLoc;
    }

    protected TokenBufferReadContext() {
        super(0, -1);
        this._parent = null;
        this._startLocation = TokenStreamLocation.NA;
    }

    protected TokenBufferReadContext(TokenBufferReadContext parent, int type, int index) {
        super(type, index);
        this._parent = parent;
        this._startLocation = parent._startLocation;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static TokenBufferReadContext createRootContext(TokenStreamContext origContext) {
        if (origContext == null) {
            return new TokenBufferReadContext();
        }
        return new TokenBufferReadContext(origContext, ContentReference.unknown());
    }

    public TokenBufferReadContext createChildArrayContext() {
        ++this._index;
        return new TokenBufferReadContext(this, 1, -1);
    }

    public TokenBufferReadContext createChildObjectContext() {
        ++this._index;
        return new TokenBufferReadContext(this, 2, -1);
    }

    public TokenBufferReadContext parentOrCopy() {
        if (this._parent instanceof TokenBufferReadContext) {
            return (TokenBufferReadContext)this._parent;
        }
        if (this._parent == null) {
            return new TokenBufferReadContext();
        }
        return new TokenBufferReadContext(this._parent, this._startLocation);
    }

    public String currentName() {
        return this._currentName;
    }

    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public TokenStreamContext getParent() {
        return this._parent;
    }

    public void setCurrentName(String name) {
        this._currentName = name;
    }

    public void updateForValue() {
        ++this._index;
    }
}

