/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.node.NumericNode;

public abstract class NumericFPNode
extends NumericNode {
    private static final long serialVersionUID = 3L;

    @Override
    public final JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public final boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public final boolean canConvertToInt() {
        return this.canConvertToExactIntegral() && this._inIntRange();
    }

    @Override
    public final boolean canConvertToLong() {
        return this.canConvertToExactIntegral() && this._inLongRange();
    }

    @Override
    public final boolean canConvertToExactIntegral() {
        return !this.isNaN() && !this._hasFractionalPart();
    }

    @Override
    public final short shortValue() {
        if (!this._inShortRange()) {
            return this._reportShortCoercionRangeFail("shortValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportShortCoercionFractionFail("shortValue()");
        }
        return this._asShortValueUnchecked();
    }

    @Override
    public final int intValue() {
        if (!this._inIntRange()) {
            if (this.isNaN()) {
                this._reportIntCoercionNaNFail("intValue()");
            }
            return this._reportIntCoercionRangeFail("intValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportIntCoercionFractionFail("intValue()");
        }
        return this._asIntValueUnchecked();
    }

    @Override
    public final int intValue(int defaultValue) {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return this._asIntValueUnchecked();
    }

    @Override
    public final OptionalInt intValueOpt() {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this._asIntValueUnchecked());
    }

    @Override
    public int asInt() {
        if (!this._inIntRange()) {
            if (this.isNaN()) {
                this._reportIntCoercionNaNFail("asInt()");
            }
            return this._reportIntCoercionRangeFail("asInt()");
        }
        return this._asIntValueUnchecked();
    }

    @Override
    public int asInt(int defaultValue) {
        if (!this._inIntRange()) {
            return defaultValue;
        }
        return this._asIntValueUnchecked();
    }

    @Override
    public OptionalInt asIntOpt() {
        if (!this._inIntRange()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this._asIntValueUnchecked());
    }

    @Override
    public final long longValue() {
        if (!this._inLongRange()) {
            if (this.isNaN()) {
                this._reportLongCoercionNaNFail("longValue()");
            }
            return this._reportLongCoercionRangeFail("longValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportLongCoercionFractionFail("longValue()");
        }
        return this._asLongValueUnchecked();
    }

    @Override
    public final long longValue(long defaultValue) {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return this._asLongValueUnchecked();
    }

    @Override
    public final OptionalLong longValueOpt() {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this._asLongValueUnchecked());
    }

    @Override
    public final long asLong() {
        if (!this._inLongRange()) {
            if (this.isNaN()) {
                this._reportLongCoercionNaNFail("asLong()");
            }
            return this._reportLongCoercionRangeFail("asLong()");
        }
        return this._asLongValueUnchecked();
    }

    @Override
    public final long asLong(long defaultValue) {
        if (!this._inLongRange()) {
            return defaultValue;
        }
        return this._asLongValueUnchecked();
    }

    @Override
    public final OptionalLong asLongOpt() {
        if (!this._inLongRange()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this._asLongValueUnchecked());
    }

    @Override
    public final BigInteger bigIntegerValue() {
        if (this.isNaN()) {
            this._reportBigIntegerCoercionNaNFail("bigIntegerValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportBigIntegerCoercionFractionFail("bigIntegerValue()");
        }
        return this._asBigIntegerValueUnchecked();
    }

    @Override
    public final BigInteger bigIntegerValue(BigInteger defaultValue) {
        if (this.isNaN() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return this._asBigIntegerValueUnchecked();
    }

    @Override
    public final Optional<BigInteger> bigIntegerValueOpt() {
        if (this.isNaN() || this._hasFractionalPart()) {
            return Optional.empty();
        }
        return Optional.of(this._asBigIntegerValueUnchecked());
    }

    @Override
    public final BigInteger asBigInteger() {
        if (this.isNaN()) {
            this._reportBigIntegerCoercionNaNFail("asBigInteger()");
        }
        return this._asBigIntegerValueUnchecked();
    }

    @Override
    public final BigInteger asBigInteger(BigInteger defaultValue) {
        if (this.isNaN()) {
            return defaultValue;
        }
        return this._asBigIntegerValueUnchecked();
    }

    @Override
    public final Optional<BigInteger> asBigIntegerOpt() {
        if (this.isNaN()) {
            return Optional.empty();
        }
        return Optional.of(this._asBigIntegerValueUnchecked());
    }

    @Override
    public BigDecimal decimalValue() {
        if (this.isNaN()) {
            this._reportBigDecimalCoercionNaNFail("decimalValue()");
        }
        return this._asDecimalValueUnchecked();
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        if (this.isNaN()) {
            return defaultValue;
        }
        return this._asDecimalValueUnchecked();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        if (this.isNaN()) {
            return Optional.empty();
        }
        return Optional.of(this._asDecimalValueUnchecked());
    }

    @Override
    public BigDecimal asDecimal() {
        if (this.isNaN()) {
            this._reportBigDecimalCoercionNaNFail("asDecimal()");
        }
        return this._asDecimalValueUnchecked();
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        if (this.isNaN()) {
            return defaultValue;
        }
        return this._asDecimalValueUnchecked();
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        if (this.isNaN()) {
            return Optional.empty();
        }
        return Optional.of(this._asDecimalValueUnchecked());
    }

    protected abstract short _asShortValueUnchecked();

    protected abstract int _asIntValueUnchecked();

    protected abstract long _asLongValueUnchecked();

    protected abstract BigInteger _asBigIntegerValueUnchecked();

    protected abstract BigDecimal _asDecimalValueUnchecked();

    protected abstract boolean _hasFractionalPart();

    protected abstract boolean _inShortRange();

    protected abstract boolean _inIntRange();

    protected abstract boolean _inLongRange();
}

