/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.module;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.ClassKey;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.MapType;

public class SimpleSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected HashMap<ClassKey, ValueSerializer<?>> _classMappings = null;
    protected HashMap<ClassKey, ValueSerializer<?>> _interfaceMappings = null;
    protected boolean _hasEnumSerializer = false;

    public SimpleSerializers() {
    }

    public SimpleSerializers(List<ValueSerializer<?>> sers) {
        this.addSerializers(sers);
    }

    public SimpleSerializers addSerializer(ValueSerializer<?> ser) {
        Class<?> cls = ser.handledType();
        if (cls == null || cls == Object.class) {
            throw new IllegalArgumentException("`ValueSerializer` of type `" + ser.getClass().getName() + "` does not define valid handledType() -- must either register with method that takes type argument  or make serializer extend 'tools.jackson.databind.ser.std.StdSerializer'");
        }
        this._addSerializer(cls, ser);
        return this;
    }

    public <T> SimpleSerializers addSerializer(Class<? extends T> type, ValueSerializer<T> ser) {
        this._addSerializer(type, ser);
        return this;
    }

    public SimpleSerializers addSerializers(List<ValueSerializer<?>> sers) {
        for (ValueSerializer<?> ser : sers) {
            this.addSerializer(ser);
        }
        return this;
    }

    @Override
    public ValueSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides) {
        Class<?> cls = type.getRawClass();
        ClassKey key = new ClassKey(cls);
        ValueSerializer<?> ser = null;
        if (cls.isInterface()) {
            if (this._interfaceMappings != null && (ser = this._interfaceMappings.get(key)) != null) {
                return ser;
            }
        } else if (this._classMappings != null) {
            ser = this._classMappings.get(key);
            if (ser != null) {
                return ser;
            }
            if (this._hasEnumSerializer && type.isEnumType()) {
                key.reset(Enum.class);
                ser = this._classMappings.get(key);
                if (ser != null) {
                    return ser;
                }
            }
            for (Class<?> curr = cls; curr != null; curr = curr.getSuperclass()) {
                key.reset(curr);
                ser = this._classMappings.get(key);
                if (ser == null) continue;
                return ser;
            }
        }
        if (this._interfaceMappings != null) {
            ser = this._findInterfaceMapping(cls, key);
            if (ser != null) {
                return ser;
            }
            if (!cls.isInterface()) {
                while ((cls = cls.getSuperclass()) != null) {
                    ser = this._findInterfaceMapping(cls, key);
                    if (ser == null) continue;
                    return ser;
                }
            }
        }
        return null;
    }

    @Override
    public ValueSerializer<?> findArraySerializer(SerializationConfig config, ArrayType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type, beanDesc, formatOverrides);
    }

    @Override
    public ValueSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type, beanDesc, formatOverrides);
    }

    @Override
    public ValueSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type, beanDesc, formatOverrides);
    }

    @Override
    public ValueSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, ValueSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type, beanDesc, formatOverrides);
    }

    @Override
    public ValueSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, ValueSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type, beanDesc, formatOverrides);
    }

    protected ValueSerializer<?> _findInterfaceMapping(Class<?> cls, ClassKey key) {
        for (Class<?> iface : cls.getInterfaces()) {
            key.reset(iface);
            ValueSerializer<?> ser = this._interfaceMappings.get(key);
            if (ser != null) {
                return ser;
            }
            ser = this._findInterfaceMapping(iface, key);
            if (ser == null) continue;
            return ser;
        }
        return null;
    }

    protected void _addSerializer(Class<?> cls, ValueSerializer<?> ser) {
        ClassKey key = new ClassKey(cls);
        if (cls.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(key, ser);
        } else {
            if (this._classMappings == null) {
                this._classMappings = new HashMap();
            }
            this._classMappings.put(key, ser);
            if (cls == Enum.class) {
                this._hasEnumSerializer = true;
            }
        }
    }
}

