/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.TreeNode;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.tree.ArrayTreeNode;
import tools.jackson.core.tree.ObjectTreeNode;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.GeneratorSettings;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.exc.InvalidTypeIdException;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.SerializerCache;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.WritableObjectId;
import tools.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import tools.jackson.databind.ser.impl.TypeWrappedSerializer;
import tools.jackson.databind.ser.impl.UnknownSerializer;
import tools.jackson.databind.ser.std.NullSerializer;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.TokenBuffer;

public abstract class SerializationContext
extends DatabindContext
implements ObjectWriteContext {
    protected static final ValueSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final GeneratorSettings _generatorConfig;
    protected final TokenStreamFactory _streamFactory;
    protected transient JsonGenerator _generator;
    protected JacksonFeatureSet<StreamWriteCapability> _writeCapabilities;
    protected final Class<?> _activeView;
    protected final SerializerFactory _serializerFactory;
    protected final ValueSerializer<Object> _nullValueSerializer;
    protected final boolean _stdNullValueSerializer;
    protected final SerializerCache _serializerCache;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected transient ClassIntrospector _classIntrospector;
    protected ContextAttributes _attributes;

    protected SerializationContext(TokenStreamFactory streamFactory, SerializationConfig config, GeneratorSettings generatorConfig, SerializerFactory f, SerializerCache cache) {
        this._streamFactory = streamFactory;
        this._serializerFactory = f;
        this._config = config;
        this._generatorConfig = generatorConfig;
        this._serializerCache = cache;
        NullSerializer ser = f.getDefaultNullValueSerializer();
        if (ser == null) {
            this._stdNullValueSerializer = true;
            ser = NullSerializer.instance;
        } else {
            this._stdNullValueSerializer = false;
        }
        this._nullValueSerializer = ser;
        this._activeView = config.getActiveView();
        this._attributes = config.getAttributes();
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
    }

    protected SerializationContext(SerializationContext src, SerializerCache serializerCache) {
        this._streamFactory = src._streamFactory;
        this._serializerFactory = src._serializerFactory;
        this._config = src._config;
        this._generatorConfig = src._generatorConfig;
        this._serializerCache = serializerCache;
        this._stdNullValueSerializer = src._stdNullValueSerializer;
        this._nullValueSerializer = src._nullValueSerializer;
        this._activeView = src._activeView;
        this._attributes = src._attributes;
        this._knownSerializers = src._knownSerializers;
    }

    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory;
    }

    public FormatSchema getSchema() {
        return this._generatorConfig.getSchema();
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._generatorConfig.getCharacterEscapes();
    }

    public PrettyPrinter getPrettyPrinter() {
        PrettyPrinter pp = this._generatorConfig.getPrettyPrinter();
        if (pp == null && this.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            pp = this._config.constructDefaultPrettyPrinter();
        }
        return pp;
    }

    public boolean hasPrettyPrinter() {
        return this._generatorConfig.hasPrettyPrinter() || this.isEnabled(SerializationFeature.INDENT_OUTPUT);
    }

    public SerializableString getRootValueSeparator(SerializableString defaultSeparator) {
        return this._generatorConfig.getRootValueSeparator(defaultSeparator);
    }

    public int getStreamWriteFeatures(int defaults) {
        return this._config.getStreamWriteFeatures();
    }

    public int getFormatWriteFeatures(int defaults) {
        return this._config.getFormatWriteFeatures();
    }

    public ArrayTreeNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public ObjectTreeNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(JsonGenerator gen, Object value) throws JacksonException {
        JsonGenerator prevGen = this._generator;
        this._generator = gen;
        try {
            if (value == null) {
                if (this._stdNullValueSerializer) {
                    gen.writeNull();
                } else {
                    this._nullValueSerializer.serialize(null, gen, this);
                }
                return;
            }
            Class<?> cls = value.getClass();
            this.findTypedValueSerializer(cls, true).serialize(value, gen, this);
        }
        finally {
            this._generator = prevGen;
        }
    }

    public void writeTree(JsonGenerator gen, TreeNode tree) throws JacksonException {
        this.writeValue(gen, tree);
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) throws IllegalArgumentException {
        if (baseType.hasRawClass(subclass)) {
            return baseType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(baseType, subclass, true);
    }

    @Override
    public final Class<?> getActiveView() {
        return this._activeView;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final DatatypeFeatures getDatatypeFeatures() {
        return this._config.getDatatypeFeatures();
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> baseType) {
        return this._config.getDefaultPropertyFormat(baseType);
    }

    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> baseType) {
        return this._config.getDefaultPropertyInclusion(baseType);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    protected ClassIntrospector classIntrospector() {
        if (this._classIntrospector == null) {
            this._classIntrospector = this._config.classIntrospectorInstance();
        }
        return this._classIntrospector;
    }

    @Override
    public BeanDescription introspectBeanDescription(JavaType type) {
        return this.classIntrospector().introspectForSerialization(type);
    }

    @Override
    public PropertyName findRootName(JavaType rootType) {
        return this._config.findRootName((DatabindContext)this, rootType);
    }

    @Override
    public PropertyName findRootName(Class<?> rawRootType) {
        return this._config.findRootName((DatabindContext)this, rawRootType);
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attributes.getAttribute(key);
    }

    @Override
    public SerializationContext setAttribute(Object key, Object value) {
        this._attributes = this._attributes.withPerCallAttribute(key, value);
        return this;
    }

    public final boolean isEnabled(SerializationFeature feature) {
        return this._config.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int featureMask) {
        return this._config.hasSerializationFeatures(featureMask);
    }

    public final boolean isEnabled(StreamWriteCapability cap) {
        return this._writeCapabilities.isEnabled((JacksonFeature)cap);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public TokenBuffer bufferForValueConversion() {
        return new TokenBuffer(this, false);
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public ValueSerializer<Object> findTypedValueSerializer(Class<?> rawType, boolean cache) {
        TypeWrappedSerializer ser = this._knownSerializers.typedValueSerializer(rawType);
        if (ser != null) {
            return ser;
        }
        JavaType fullType = this._config.constructType(rawType);
        ser = this.handleRootContextualization(this.findValueSerializer(rawType));
        TypeSerializer typeSer = this.findTypeSerializer(fullType);
        if (typeSer != null) {
            typeSer = typeSer.forProperty(this, null);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(rawType, ser);
        }
        return ser;
    }

    public ValueSerializer<Object> findTypedValueSerializer(JavaType valueType, boolean cache) {
        TypeWrappedSerializer ser = this._knownSerializers.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this.handleRootContextualization(this.findValueSerializer(valueType));
        TypeSerializer typeSer = this.findTypeSerializer(valueType);
        if (typeSer != null) {
            typeSer = typeSer.forProperty(this, null);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(valueType, ser);
        }
        return ser;
    }

    public ValueSerializer<Object> findRootValueSerializer(Class<?> rawType) {
        JavaType fullType;
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCacheUntypedSerializer(rawType, fullType);
        }
        return this.handleRootContextualization(ser);
    }

    public ValueSerializer<Object> findRootValueSerializer(JavaType valueType) {
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCacheUntypedSerializer(valueType);
        }
        return this.handleRootContextualization(ser);
    }

    public ValueSerializer<Object> findPrimaryPropertySerializer(JavaType valueType, BeanProperty property) {
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCachePropertySerializer(valueType, property);
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public ValueSerializer<Object> findPrimaryPropertySerializer(Class<?> rawType, BeanProperty property) {
        JavaType fullType;
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCachePropertySerializer(rawType, fullType, property);
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public ValueSerializer<Object> findContentValueSerializer(JavaType valueType, BeanProperty property) {
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCachePropertySerializer(valueType, property);
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public ValueSerializer<Object> findContentValueSerializer(Class<?> rawType, BeanProperty property) {
        JavaType fullType;
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCachePropertySerializer(rawType, fullType, property);
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public ValueSerializer<Object> findValueSerializer(Class<?> rawType) {
        JavaType fullType;
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCacheUntypedSerializer(rawType, fullType);
        }
        return ser;
    }

    public ValueSerializer<Object> findValueSerializer(JavaType valueType) {
        ValueSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCacheUntypedSerializer(valueType);
        }
        return ser;
    }

    public TypeSerializer findTypeSerializer(JavaType baseType) {
        return this.findTypeSerializer(baseType, this.introspectClassAnnotations(baseType));
    }

    public TypeSerializer findTypeSerializer(JavaType baseType, AnnotatedClass classAnnotations) {
        return this._config.getTypeResolverProvider().findTypeSerializer(this, baseType, classAnnotations);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, AnnotatedMember accessor) {
        return this._config.getTypeResolverProvider().findPropertyTypeSerializer(this, accessor, baseType);
    }

    public ValueSerializer<Object> findKeySerializer(JavaType keyType, BeanProperty property) {
        ValueSerializer<Object> ser = this._serializerFactory.createKeySerializer(this, keyType);
        ser.resolve(this);
        return this.handleSecondaryContextualization(ser, property);
    }

    public ValueSerializer<Object> findKeySerializer(Class<?> rawKeyType, BeanProperty property) {
        return this.findKeySerializer(this._config.constructType(rawKeyType), property);
    }

    public ValueSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public ValueSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty property) {
        return this._serializerFactory.getDefaultNullKeySerializer();
    }

    public ValueSerializer<Object> findNullValueSerializer(BeanProperty property) {
        return this._nullValueSerializer;
    }

    public ValueSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        if (unknownType == Object.class) {
            return DEFAULT_UNKNOWN_SERIALIZER;
        }
        return new UnknownSerializer(unknownType);
    }

    public boolean isUnknownTypeSerializer(ValueSerializer<?> ser) {
        if (ser == DEFAULT_UNKNOWN_SERIALIZER || ser == null) {
            return true;
        }
        return this.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS) && ser instanceof UnknownSerializer;
    }

    protected ValueSerializer<Object> _createAndCacheUntypedSerializer(Class<?> rawType, JavaType fullType) {
        ValueSerializer<Object> ser;
        BeanDescription beanDesc = this.introspectBeanDescription(fullType);
        try {
            ser = this._serializerFactory.createSerializer(this, fullType, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            this.reportBadTypeDefinition(beanDesc, ClassUtil.exceptionMessage(iae), new Object[0]);
            ser = null;
        }
        this._serializerCache.addAndResolveNonTypedSerializer(rawType, fullType, ser, this);
        return ser;
    }

    protected ValueSerializer<Object> _createAndCacheUntypedSerializer(JavaType type) {
        ValueSerializer<Object> ser;
        BeanDescription beanDesc = this.introspectBeanDescription(type);
        try {
            ser = this._serializerFactory.createSerializer(this, type, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        return ser;
    }

    protected ValueSerializer<Object> _createAndCachePropertySerializer(Class<?> rawType, JavaType fullType, BeanProperty prop) {
        ValueSerializer<Object> ser;
        BeanDescription beanDesc = this.introspectBeanDescription(fullType);
        try {
            ser = this._serializerFactory.createSerializer(this, fullType, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(rawType, fullType, ser, this);
        if (prop == null) {
            return ser;
        }
        return this._checkShapeShifting(fullType, beanDesc, prop, ser);
    }

    protected ValueSerializer<Object> _createAndCachePropertySerializer(JavaType type, BeanProperty prop) {
        ValueSerializer<Object> ser;
        BeanDescription beanDesc = this.introspectBeanDescription(type);
        try {
            ser = this._serializerFactory.createSerializer(this, type, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        if (prop == null) {
            return ser;
        }
        return this._checkShapeShifting(type, beanDesc, prop, ser);
    }

    private ValueSerializer<Object> _checkShapeShifting(JavaType type, BeanDescription beanDesc, BeanProperty prop, ValueSerializer<?> ser) {
        JsonFormat.Value overrides = prop.findFormatOverrides(this._config);
        if (overrides != null) {
            ValueSerializer<?> ser2 = ser.withFormatOverrides(this._config, overrides);
            ser = ser2 != null ? ser2 : this._serializerFactory.createSerializer(this, type, beanDesc, overrides);
        }
        return ser;
    }

    protected ValueSerializer<Object> _handleResolvable(ValueSerializer<?> ser) {
        ser.resolve(this);
        return ser;
    }

    public abstract ValueSerializer<Object> serializerInstance(Annotated var1, Object var2);

    public abstract Object includeFilterInstance(BeanPropertyDefinition var1, Class<?> var2);

    public abstract boolean includeFilterSuppressNulls(Object var1);

    public ValueSerializer<Object> handlePrimaryContextualization(ValueSerializer<?> ser, BeanProperty property) {
        if (ser != null) {
            ser = ser.createContextual(this, property);
        }
        return ser;
    }

    public ValueSerializer<Object> handleSecondaryContextualization(ValueSerializer<?> ser, BeanProperty property) {
        if (ser != null) {
            ser = ser.createContextual(this, property);
        }
        return ser;
    }

    public ValueSerializer<Object> handleRootContextualization(ValueSerializer<?> ser) {
        if (ser != null) {
            ser = ser.createContextual(this, null);
        }
        return ser;
    }

    public final void defaultSerializeProperty(String propertyName, Object value, JsonGenerator g) throws JacksonException {
        g.writeName(propertyName);
        this.writeValue(g, value);
    }

    public final void defaultSerializeDateValue(long timestamp, JsonGenerator g) throws JacksonException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            g.writeNumber(timestamp);
        } else {
            g.writeString(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator g) throws JacksonException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            g.writeNumber(date.getTime());
        } else {
            g.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long timestamp, JsonGenerator g) throws JacksonException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            g.writeName(String.valueOf(timestamp));
        } else {
            g.writeName(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator g) throws JacksonException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            g.writeName(String.valueOf(date.getTime()));
        } else {
            g.writeName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNullValue(JsonGenerator g) throws JacksonException {
        if (this._stdNullValueSerializer) {
            g.writeNull();
        } else {
            this._nullValueSerializer.serialize(null, g, this);
        }
    }

    public abstract <T extends JsonNode> T valueToTree(Object var1) throws JacksonException;

    @Override
    public <T> T reportBadTypeDefinition(BeanDescription bean, String msg, Object ... msgArgs) throws DatabindException {
        String beanDesc = "N/A";
        if (bean != null) {
            beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        }
        msg = String.format("Invalid type definition for type %s: %s", beanDesc, this._format(msg, msgArgs));
        throw InvalidDefinitionException.from(this.getGenerator(), msg, bean, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription bean, BeanPropertyDefinition prop, String message, Object ... msgArgs) throws DatabindException {
        message = this._format(message, msgArgs);
        String propName = "N/A";
        if (prop != null) {
            propName = this._quotedString(prop.getName());
        }
        String beanDesc = "N/A";
        if (bean != null) {
            beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        }
        message = String.format("Invalid definition for property %s (of type %s): %s", propName, beanDesc, message);
        throw InvalidDefinitionException.from(this.getGenerator(), message, bean, prop);
    }

    @Override
    public <T> T reportBadDefinition(JavaType type, String msg) throws DatabindException {
        throw InvalidDefinitionException.from(this.getGenerator(), msg, type);
    }

    public <T> T reportBadDefinition(JavaType type, String msg, Throwable cause) throws DatabindException {
        throw InvalidDefinitionException.from(this.getGenerator(), msg, type).withCause(cause);
    }

    public <T> T reportBadDefinition(Class<?> raw, String msg, Throwable cause) throws DatabindException {
        throw InvalidDefinitionException.from(this.getGenerator(), msg, this.constructType(raw)).withCause(cause);
    }

    public void reportMappingProblem(Throwable t, String message, Object ... msgArgs) throws DatabindException {
        throw this._mappingProblem(t, message, msgArgs);
    }

    protected DatabindException _mappingProblem(Throwable t, String message, Object ... msgArgs) {
        return DatabindException.from(this.getGenerator(), this._format(message, msgArgs), t);
    }

    public void reportMappingProblem(String message, Object ... msgArgs) throws DatabindException {
        throw DatabindException.from(this.getGenerator(), this._format(message, msgArgs));
    }

    @Override
    public DatabindException invalidTypeIdException(JavaType baseType, String typeId, String extraDesc) {
        String msg = String.format("Could not resolve type id '%s' as a subtype of %s", typeId, ClassUtil.getTypeDescription(baseType));
        return InvalidTypeIdException.from(null, this._colonConcat(msg, extraDesc), baseType, typeId);
    }

    protected void _reportIncompatibleRootType(Object value, JavaType rootType) throws JacksonException {
        Class<?> wrapperType;
        if (rootType.isPrimitive() && (wrapperType = ClassUtil.wrapperType(rootType.getRawClass())).isAssignableFrom(value.getClass())) {
            return;
        }
        this.reportBadDefinition(rootType, String.format("Incompatible types: declared root type (%s) vs %s", rootType, ClassUtil.classNameOf(value)));
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }
}

