/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.importer;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.commons.reflect.PropertyInfo;
import tools.dynamia.domain.ValidationError;
import tools.dynamia.integration.ProgressMonitor;
import tools.dynamia.modules.importer.ImportBeanParser;
import tools.dynamia.modules.importer.ImportReader;

public class ImportUtils {
    private static final LoggingService LOGGER = new SLF4JLoggingService(ImportUtils.class);

    public static String getCellValue(Row row, int cellIndex) {
        String value = null;
        Cell cell = row.getCell(cellIndex);
        if (cell != null) {
            if (cell.getCellType() == CellType.ERROR) {
                value = null;
            } else if (cell.getCellType() == CellType.NUMERIC) {
                DataFormatter df = new DataFormatter();
                value = df.formatCellValue(cell);
            } else {
                value = cell.getStringCellValue();
            }
        }
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static Object getCellValueObject(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (cell != null) {
            CellType type = cell.getCellType();
            switch (type) {
                case BLANK: {
                    return null;
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
                case FORMULA: {
                    String formula = cell.getCellFormula();
                    if ("TRUE()".equalsIgnoreCase(formula)) {
                        return Boolean.TRUE;
                    }
                    if ("FALSE()".equalsIgnoreCase(formula)) {
                        return Boolean.FALSE;
                    }
                    return cell.getCellFormula();
                }
            }
            return cell.getStringCellValue();
        }
        return null;
    }

    public static Date getCellValueDate(Row row, int cellIndex) {
        try {
            Cell cell = row.getCell(cellIndex);
            if (cell != null) {
                return cell.getDateCellValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> List<T> importExcel(Class<T> clazz, InputStream excelFile, ProgressMonitor monitor, ImportBeanParser<T> parser) throws Exception {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        Workbook workbook = WorkbookFactory.create((InputStream)excelFile);
        Sheet sheet = workbook.getSheetAt(0);
        monitor.setMax((long)sheet.getLastRowNum());
        ArrayList<T> lineas = new ArrayList<T>();
        int filasOK = 0;
        for (Row row : sheet) {
            if (row.getRowNum() == 0) {
                monitor.setMessage("Processing header");
            } else {
                try {
                    T bean = parser.parse(row);
                    if (bean != null) {
                        if (!lineas.contains(bean)) {
                            lineas.add(bean);
                        }
                        ++filasOK;
                    }
                    monitor.setMessage("Fila " + row.getRowNum() + " de " + sheet.getLastRowNum() + " procesadas");
                }
                catch (ValidationError validationError) {
                    monitor.setMessage("Error importando fila " + row.getRowNum() + ". " + validationError.getMessage());
                }
            }
            monitor.setCurrent((long)row.getRowNum());
            if (!monitor.isStopped()) continue;
            break;
        }
        return lineas;
    }

    public static void readExcel(InputStream excelFile, ProgressMonitor monitor, ImportReader reader) throws Exception {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        Workbook workbook = WorkbookFactory.create((InputStream)excelFile);
        Sheet sheet = workbook.getSheetAt(0);
        monitor.setMax((long)sheet.getLastRowNum());
        int filasOK = 0;
        for (Row row : sheet) {
            if (row.getRowNum() == 0) {
                monitor.setMessage("Procesando Encabezados");
            } else {
                try {
                    reader.read(row);
                    ++filasOK;
                    monitor.setMessage("Fila " + row.getRowNum() + " importada Ok");
                }
                catch (ValidationError error) {
                    monitor.setMessage("Error importando fila " + row.getRowNum() + ". " + error.getMessage());
                    throw error;
                }
            }
            monitor.setCurrent((long)row.getRowNum());
        }
    }

    public static void tryToParse(Row row, Object bean, String ... fields) {
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                try {
                    String fieldName = fields[i];
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    Object value = ImportUtils.getCellValueObject(row, i);
                    if (value instanceof Double) {
                        PropertyInfo field = BeanUtils.getPropertyInfo(bean.getClass(), (String)fieldName);
                        if (field.is(BigDecimal.class)) {
                            value = BigDecimal.valueOf(((Number)value).doubleValue());
                        } else if (field.is(Integer.class) || field.is(Integer.TYPE)) {
                            value = ((Double)value).intValue();
                        } else if (field.is(Long.class) || field.is(Long.TYPE)) {
                            value = ((Double)value).longValue();
                        }
                    }
                    BeanUtils.setFieldValue((String)fieldName, (Object)bean, (Object)value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static Cell findFirstRowCellByName(Sheet sheet, String columnName) {
        for (Cell cell : sheet.getRow(0)) {
            if (!columnName.equalsIgnoreCase(cell.getStringCellValue())) continue;
            return cell;
        }
        return null;
    }

    public static String getCellValue(Row row, String columnName) {
        Cell cell = ImportUtils.findFirstRowCellByName(row.getSheet(), columnName);
        if (cell != null) {
            return ImportUtils.getCellValue(row, cell.getColumnIndex());
        }
        return null;
    }

    public static Object getCellValueObject(Row row, String columnName) {
        Cell cell = ImportUtils.findFirstRowCellByName(row.getSheet(), columnName);
        if (cell != null) {
            return ImportUtils.getCellValueObject(row, cell.getColumnIndex());
        }
        return null;
    }

    public static Date getCellValueDate(Row row, String columnName) {
        Cell cell = ImportUtils.findFirstRowCellByName(row.getSheet(), columnName);
        if (cell != null) {
            return ImportUtils.getCellValueDate(row, cell.getColumnIndex());
        }
        return null;
    }

    public static Cell findCellByCoordinate(Sheet sheet, String coordinate) {
        try {
            CellReference ref = new CellReference(coordinate);
            Row row = sheet.getRow(ref.getRow());
            if (row != null) {
                return row.getCell((int)ref.getCol());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static void setCellValue(Cell cell, Object value) {
        if (cell != null && value != null) {
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (value instanceof Calendar) {
                cell.setCellValue((Calendar)value);
            } else {
                cell.setCellValue(value.toString());
            }
        }
    }

    public static BigDecimal parseBigDecimal(Row row, int cellIndex, BigDecimal defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Number) {
                    double precioVta = ((Number)value).doubleValue();
                    return BigDecimal.valueOf(precioVta);
                }
                return new BigDecimal(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing BigDecimal: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static boolean parseBoolean(Row row, int cellIndex, boolean defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                return value.toString().equalsIgnoreCase("si") || value.toString().equalsIgnoreCase("1") || value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("yes");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Boolean: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static Boolean parseBooleanObject(Row row, int cellIndex, Boolean defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                return value.toString().equalsIgnoreCase("si") || value.toString().equalsIgnoreCase("1") || value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("yes");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Boolean: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static double parseDouble(Row row, int cellIndex, double defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return Double.parseDouble(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Double: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static Double parseDoubleObject(Row row, int cellIndex, Double defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return Double.parseDouble(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Double: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static int parseInt(Row row, int cellIndex, int defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.parseInt(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Int: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static Integer parseIntObject(Row row, int cellIndex, Integer defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.parseInt(value.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Int: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static String parseString(Row row, int cellIndex, String defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof Number) {
                    return String.valueOf(((Number)value).longValue());
                }
                return value.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing String: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }

    public static Date parseDate(Row row, int cellIndex, Date defaultValue, String message) {
        try {
            Object value = ImportUtils.getCellValueObject(row, cellIndex);
            if (value != null) {
                if (value instanceof Date) {
                    return (Date)value;
                }
                if (value instanceof Number) {
                    return DateUtil.getJavaDate((double)((Number)value).doubleValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing Date: " + message + "  Location: " + row.getRowNum() + "  / " + cellIndex, (Throwable)e);
        }
        return defaultValue;
    }
}

