/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import tools.devnull.jenkins.plugins.buildnotifications.BaseNotifier;
import tools.devnull.jenkins.plugins.buildnotifications.Message;
import tools.devnull.jenkins.plugins.buildnotifications.SlackMessage;

public class SlackNotifier
extends BaseNotifier {
    @DataBoundConstructor
    public SlackNotifier(String globalTarget, String successfulTarget, String brokenTarget, String stillBrokenTarget, String fixedTarget, boolean sendIfSuccess, String extraMessage) {
        super(globalTarget, successfulTarget, brokenTarget, stillBrokenTarget, fixedTarget, sendIfSuccess, extraMessage);
    }

    @Override
    protected Message createMessage(String target, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SlackDescriptor descriptor = (SlackDescriptor)this.getDescriptor();
        return new SlackMessage(descriptor.getBotToken(), target, this.replaceEnvString(build, this.getExtraMessage()));
    }

    @Extension
    public static class SlackDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String botToken;

        public SlackDescriptor() {
            this.load();
        }

        public String getBotToken() {
            return this.botToken;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            JSONObject config = json.getJSONObject("slack");
            this.botToken = config.getString("botToken");
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Slack Notification";
        }
    }
}

