/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class SlackMessage
implements Message {
    private static final Logger LOGGER = Logger.getLogger(SlackMessage.class.getName());
    private final String botToken;
    private final String channelIds;
    private String extraMessage;
    private String content;
    private String title;
    private String url;
    private String urlTitle;

    public SlackMessage(String botToken, String channelIds, String extraMessage) {
        this.botToken = botToken;
        this.channelIds = channelIds;
        this.extraMessage = extraMessage;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrl(String url, String title) {
        this.url = url;
        this.urlTitle = title;
    }

    @Override
    public void highPriority() {
    }

    @Override
    public void normalPriority() {
    }

    @Override
    public void lowPriority() {
    }

    @Override
    public void send() {
        String[] ids = this.channelIds.split("\\s*,\\s*");
        HttpClient client = new HttpClient();
        for (String channelId : ids) {
            PostMethod post = new PostMethod("https://slack.com/api/chat.postMessage");
            post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            post.setRequestBody(new NameValuePair[]{new NameValuePair("token", this.botToken), new NameValuePair("as_user", "true"), new NameValuePair("channel", channelId), new NameValuePair("text", this.getMessage())});
            try {
                client.executeMethod((HttpMethod)post);
            }
            catch (IOException e) {
                LOGGER.severe("Error while sending notification: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String getMessage() {
        return String.format("%s%n%n%s%n%n%s <%s>%n%n%s", this.title, this.content, this.urlTitle, this.url, this.extraMessage);
    }
}

