/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class TelegramMessage
implements Message {
    private static final Logger LOGGER = Logger.getLogger(TelegramMessage.class.getName());
    private final String botToken;
    private final String chatIds;
    private String content;
    private String title;
    private String url;
    private String urlTitle;

    public TelegramMessage(String botToken, String chatIds) {
        this.botToken = botToken;
        this.chatIds = chatIds;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrl(String url, String title) {
        this.url = url;
        this.urlTitle = title;
    }

    @Override
    public void highPriority() {
    }

    @Override
    public void normalPriority() {
    }

    @Override
    public void lowPriority() {
    }

    @Override
    public void send() {
        String[] ids = this.chatIds.split("\\s*,\\s*");
        HttpClient client = new HttpClient();
        for (String chatId : ids) {
            PostMethod post = new PostMethod(String.format("https://api.telegram.org/bot%s/sendMessage", this.botToken));
            post.setRequestBody(new NameValuePair[]{new NameValuePair("chat_id", chatId), new NameValuePair("text", this.getMessage())});
            try {
                client.executeMethod((HttpMethod)post);
            }
            catch (IOException e) {
                LOGGER.severe("Error while sending notification: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String getMessage() {
        return String.format("%s%n%n%s%n%n%s <%s>", this.title, this.content, this.urlTitle, this.url);
    }
}

