/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.boteco.plugins.diceroll;

import java.util.Arrays;
import java.util.function.Function;
import tools.devnull.boteco.plugins.diceroll.Dice;
import tools.devnull.boteco.plugins.diceroll.DiceRoll;
import tools.devnull.boteco.plugins.diceroll.SimpleDice;

public class SimpleDiceRoll
implements DiceRoll {
    private final Function<Integer, Dice> diceFunction;

    public SimpleDiceRoll(Function<Integer, Dice> diceFunction) {
        this.diceFunction = diceFunction;
    }

    public SimpleDiceRoll() {
        this(SimpleDice::new);
    }

    @Override
    public int roll(String expression) {
        String[] rolls = expression.split("\\s*[+]\\s*");
        if (rolls.length > 1) {
            return Arrays.stream(rolls).mapToInt(this::roll).reduce(0, (left, right) -> left + right);
        }
        return this._roll(expression);
    }

    private int _roll(String expression) {
        int total = 0;
        int dices = 0;
        int sides = 0;
        if (expression.startsWith("d")) {
            dices = 1;
            sides = Integer.parseInt(expression.substring(1));
        } else if (expression.matches("\\d+")) {
            total = Integer.parseInt(expression);
        } else {
            String[] split = expression.split("d");
            dices = Integer.parseInt(split[0]);
            sides = Integer.parseInt(split[1]);
        }
        for (int i = 0; i < dices; ++i) {
            total += this.diceFunction.apply(sides).roll();
        }
        return total;
    }
}

