/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib;

import java.util.function.Supplier;

public class Cache<T> {
    protected T value;
    protected final Supplier<T> load;

    protected Cache(Supplier<T> loadIn) {
        if (loadIn == null) {
            throw new IllegalArgumentException();
        }
        this.load = loadIn;
    }

    public T get() {
        if (this.value == null) {
            this.value = this.load.get();
        }
        return this.value;
    }

    public void release() {
        this.value = null;
    }

    public static <T> Cache<T> create(Supplier<T> loadIn) {
        return new Cache<T>(loadIn);
    }

    public static <T> Cache<T> make(Supplier<T> loadIn) {
        Cache<T> cache = Cache.create(loadIn);
        cache.get();
        return cache;
    }
}

