/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.GrilleKeyType;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.lib.util.ArrayUtil;
import javax.annotation.Nullable;

public class GrilleCipher
extends UniKeyCipher<Integer[], GrilleKeyType.Builder> {
    public GrilleCipher() {
        super((IKeyType.IKeyBuilder)GrilleKeyType.builder().setRange(2, 8));
    }

    public CharSequence normaliseText(CharSequence plainText, Integer[] key) {
        int blockSize = key.length * 4;
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, Integer[] key) {
        int blockSize = key.length * 4;
        int[] keyMapping = GrilleCipher.createFullKey(key, true);
        char[] cipherText = new char[plainText.length()];
        for (int offset = 0; offset < plainText.length(); offset += blockSize) {
            GrilleCipher.decodeSection(plainText, cipherText, offset, blockSize, keyMapping);
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, Integer[] key) {
        int blockSize = key.length * 4;
        int[] keyIndexed = GrilleCipher.createFullKey(key, false);
        for (int offset = 0; offset < cipherText.length(); offset += blockSize) {
            GrilleCipher.decodeSection(cipherText, plainText, offset, blockSize, keyIndexed);
        }
        return plainText;
    }

    private static void decodeSection(CharSequence inputText, char[] outputText, int offset, int blockSize, int[] fullKey) {
        for (int i = 0; i < blockSize; ++i) {
            outputText[offset + fullKey[i]] = inputText.charAt(offset + i);
        }
    }

    public static int[] createFullKey(Integer[] key, boolean encode) {
        int blockSize = key.length * 4;
        int middleIndex = key.length * 2;
        int size = (int)Math.sqrt(blockSize + (key.length + 1) % 2);
        boolean odd = size % 2 == 1;
        int[] normal = new int[blockSize];
        for (int i = 0; i < key.length; ++i) {
            normal[i] = key[i];
        }
        for (int rot = 1; rot < 4; ++rot) {
            for (int i = 0; i < key.length; ++i) {
                int value = normal[(rot - 1) * key.length + i];
                int row = value / size;
                int col = value % size;
                normal[rot * key.length + i] = col * size + (size - 1 - row);
            }
        }
        int[] ordered = new int[blockSize];
        int gridPos = 0;
        for (int rot = 0; rot < 4; ++rot) {
            for (int i = 0; i < size * size; ++i) {
                if (!ArrayUtil.contains((int[])normal, (int)(rot * key.length), (int)((rot + 1) * key.length), (int)i)) continue;
                int orderPos = i;
                if (odd && orderPos > middleIndex) {
                    --orderPos;
                }
                if (encode) {
                    ordered[gridPos] = orderPos;
                } else {
                    ordered[orderPos] = gridPos;
                }
                ++gridPos;
            }
        }
        return ordered;
    }
}

